/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.aspect;

import com.alibaba.fastjson.JSON;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessStatus;
import com.zsy.exam.mapper.OptLogMapper;
import com.zsy.exam.model.entity.OptLog;
import com.zsy.exam.util.IpUtils;
import com.zsy.exam.util.SecurityUtil;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Component;
import org.springframework.validation.BindingResult;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class SysLogAspect {
    private static final Logger log = LoggerFactory.getLogger(SysLogAspect.class);
    @Autowired
    private OptLogMapper optLogMapper;

    @AfterReturning(pointcut="@annotation(controllerLog)", returning="jsonResult")
    public void doAfterReturning(JoinPoint joinPoint, SysLog controllerLog, Object jsonResult) {
        this.handleLog(joinPoint, controllerLog, null, jsonResult);
    }

    @AfterThrowing(value="@annotation(controllerLog)", throwing="e")
    public void doAfterThrowing(JoinPoint joinPoint, SysLog controllerLog, Exception e) {
        this.handleLog(joinPoint, controllerLog, e, null);
    }

    protected void handleLog(JoinPoint joinPoint, SysLog controllerLog, Exception e, Object jsonResult) {
        try {
            HttpServletRequest request = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
            OptLog optLog = new OptLog();
            optLog.setOptUserId(this.getOptUserId());
            optLog.setOptUserName(this.getOptUserName());
            optLog.setStatus(BusinessStatus.SUCCESS.getType());
            optLog.setRequestIp(IpUtils.getIpAddr((HttpServletRequest)request));
            optLog.setRequestUrl(request.getRequestURI());
            if (e != null) {
                optLog.setStatus(BusinessStatus.FAIL.getType());
                optLog.setErrorMsg(StringUtils.substring((String)e.getMessage(), (int)0, (int)2000));
            }
            String className = joinPoint.getTarget().getClass().getName();
            String methodName = joinPoint.getSignature().getName();
            optLog.setMethod(className + "." + methodName + "()");
            optLog.setRequestMethod(request.getMethod());
            optLog.setUserAgent(request.getHeader("user-agent"));
            this.getControllerMethodDescription(joinPoint, controllerLog, optLog, jsonResult);
            optLog.setOptTime(LocalDateTime.now());
            this.optLogMapper.insert((Object)optLog);
        }
        catch (Exception exp) {
            log.error("==\u524d\u7f6e\u901a\u77e5\u5f02\u5e38==");
            log.error("\u5f02\u5e38\u4fe1\u606f:{}", (Object)exp.getMessage());
            exp.printStackTrace();
        }
    }

    public void getControllerMethodDescription(JoinPoint joinPoint, SysLog log, OptLog optLog, Object jsonResult) throws Exception {
        optLog.setBusinessType(log.businessType().getType());
        optLog.setTitle(log.title());
        if (log.isSaveRequestData()) {
            this.setRequestValue(joinPoint, optLog);
        }
        if (log.isSaveResponseData() && null != jsonResult) {
            optLog.setJsonResult(StringUtils.substring((String)JSON.toJSONString((Object)jsonResult), (int)0, (int)2000));
        }
    }

    private void setRequestValue(JoinPoint joinPoint, OptLog optLog) throws Exception {
        String requestMethod = optLog.getRequestMethod();
        if (HttpMethod.PUT.name().equals(requestMethod) || HttpMethod.POST.name().equals(requestMethod)) {
            String params = this.argsArrayToString(joinPoint.getArgs());
            optLog.setRequestParam(StringUtils.substring((String)params, (int)0, (int)2000));
        }
    }

    private String argsArrayToString(Object[] paramsArray) {
        Object params = "";
        if (paramsArray != null && paramsArray.length > 0) {
            for (Object o : paramsArray) {
                if (null == o || this.isFilterObject(o)) continue;
                try {
                    Object jsonObj = JSON.toJSON((Object)o);
                    params = (String)params + jsonObj.toString() + " ";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ((String)params).trim();
    }

    public boolean isFilterObject(Object o) {
        Map map;
        Iterator iterator;
        Class<?> clazz = o.getClass();
        if (clazz.isArray()) {
            return clazz.getComponentType().isAssignableFrom(MultipartFile.class);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            Collection collection = (Collection)o;
            Iterator iterator2 = collection.iterator();
            if (iterator2.hasNext()) {
                Object value = iterator2.next();
                return value instanceof MultipartFile;
            }
        } else if (Map.class.isAssignableFrom(clazz) && (iterator = (map = (Map)o).entrySet().iterator()).hasNext()) {
            Map.Entry value;
            Map.Entry entry = value = iterator.next();
            return entry.getValue() instanceof MultipartFile;
        }
        return o instanceof MultipartFile || o instanceof HttpServletRequest || o instanceof HttpServletResponse || o instanceof BindingResult;
    }

    private Long getOptUserId() {
        Long userId = SecurityUtil.getUserId();
        return userId;
    }

    private String getOptUserName() {
        String userName = SecurityUtil.getUserName();
        return userName;
    }
}

