/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.common.aop;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.PropertyPreFilters;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class LogAsPect {
    private static final Logger LOG = LoggerFactory.getLogger(LogAsPect.class);

    @Pointcut(value="execution(public * com.zsy.exam.controller..*Controller.*(..))")
    public void controllerPointcut() {
    }

    @Before(value="controllerPointcut()")
    public void doBefore(JoinPoint joinPoint) throws Throwable {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        HttpServletRequest request = attributes.getRequest();
        Signature signature = joinPoint.getSignature();
        String name = signature.getName();
        LOG.info("------------- \u5f00\u59cb -------------");
        LOG.info("\u8bf7\u6c42\u5730\u5740: {} {}", (Object)request.getRequestURL().toString(), (Object)request.getMethod());
        LOG.info("\u7c7b\u540d\u65b9\u6cd5: {}.{}", (Object)signature.getDeclaringTypeName(), (Object)name);
        LOG.info("\u8fdc\u7a0b\u5730\u5740: {}", (Object)request.getRemoteAddr());
        Object[] args = joinPoint.getArgs();
        Object[] arguments = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            if (args[i] instanceof ServletRequest || args[i] instanceof ServletResponse || args[i] instanceof MultipartFile) continue;
            arguments[i] = args[i];
        }
        String[] excludeProperties = new String[]{"password", "file"};
        PropertyPreFilters filters = new PropertyPreFilters();
        PropertyPreFilters.MySimplePropertyPreFilter excludeFilter = filters.addFilter();
        excludeFilter.addExcludes(excludeProperties);
        LOG.info("\u8bf7\u6c42\u53c2\u6570: {}", (Object)JSONObject.toJSONString((Object)arguments, (SerializeFilter)excludeFilter, (SerializerFeature[])new SerializerFeature[0]));
    }

    @Around(value="controllerPointcut()")
    public Object doAround(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        long startTime = System.currentTimeMillis();
        Object result = proceedingJoinPoint.proceed();
        String[] excludeProperties = new String[]{"password", "file"};
        PropertyPreFilters filters = new PropertyPreFilters();
        PropertyPreFilters.MySimplePropertyPreFilter excludeFilter = filters.addFilter();
        excludeFilter.addExcludes(excludeProperties);
        LOG.info("\u8fd4\u56de\u7ed3\u679c: {}", (Object)JSONObject.toJSONString((Object)result, (SerializeFilter)excludeFilter, (SerializerFeature[])new SerializerFeature[0]));
        LOG.info("------------- \u7ed3\u675f \u8017\u65f6\uff1a{} ms -------------", (Object)(System.currentTimeMillis() - startTime));
        return result;
    }
}

