/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.common.handler;

import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.common.result.Result;
import jakarta.validation.ConstraintViolationException;
import java.sql.SQLIntegrityConstraintViolationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.validation.ObjectError;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.multipart.MaxUploadSizeExceededException;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={AppException.class})
    public Result<String> handleAppException(AppException e) {
        log.error(e.getMessage(), e.getClass());
        return Result.failed((String)e.getLocalizedMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result<String> handleMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        log.error(e.getMessage(), e.getClass());
        String message = ((ObjectError)e.getBindingResult().getAllErrors().get(0)).getDefaultMessage();
        return Result.failed((String)message);
    }

    @ExceptionHandler(value={SQLIntegrityConstraintViolationException.class})
    public Result<String> handleSQLIntegrityConstraintViolationException(SQLIntegrityConstraintViolationException e) {
        log.error(e.getMessage(), e.getClass());
        return Result.failed((String)"\u91cd\u590d");
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Result<String> handleHttpMessageNotReadableException(HttpMessageNotReadableException e) {
        log.error(e.getMessage(), e.getClass());
        return Result.failed((String)"\u8bf7\u6c42\u53c2\u6570\u65e0\u6cd5\u89e3\u6790");
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result<String> handleMissingServletRequestParameterException(MissingServletRequestParameterException e) {
        log.error(e.getMessage(), e.getClass());
        return Result.failed((String)(e.getParameterName() + "\u4e3a\u5fc5\u586b\u9879"));
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public Result<String> handleDuplicateKeyException(DuplicateKeyException e) {
        String name = e.getMessage().split(":")[2].split(" ")[3];
        log.error(e.getMessage(), e.getClass());
        return Result.failed((String)("\u4e3b\u952e\u51b2\u7a81" + name + "\u5df2\u5b58\u5728"));
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public Result<String> handleAccessDeniedException(AccessDeniedException e) {
        log.error(e.getMessage(), e.getClass());
        return Result.failed((String)"\u4f60\u6ca1\u6709\u8be5\u8d44\u6e90\u7684\u8bbf\u95ee\u6743\u9650");
    }

    @ExceptionHandler(value={MaxUploadSizeExceededException.class})
    public Result<String> handlerMaxUploadSizeExceededException(MaxUploadSizeExceededException e) {
        log.error(e.getMessage(), e.getClass());
        return Result.failed((String)"\u6587\u4ef6\u592a\u5927\uff0c\u6700\u5927\u4e0a\u4f205MB");
    }

    @ExceptionHandler(value={MissingServletRequestPartException.class})
    public Result<String> handlerMissingServletRequestPartException(MissingServletRequestPartException e) {
        log.error(e.getMessage(), e.getClass());
        return Result.failed((String)"\u6ca1\u6709\u83b7\u53d6\u5230\u6587\u4ef6");
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result<String> handleConstraintViolationException(ConstraintViolationException e) {
        log.error(e.getMessage(), e.getClass());
        return Result.failed((String)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public Result<String> handleException(Exception e) {
        e.printStackTrace();
        log.error(e.getMessage(), e.getCause());
        return Result.failed((String)e.getMessage());
    }
}

