/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.config;

import com.zsy.exam.util.MinioUtil;
import io.minio.MinioClient;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class IniBucket
implements CommandLineRunner {
    private static final Logger log = LoggerFactory.getLogger(IniBucket.class);
    @Autowired
    private MinioUtil minioProp;
    @Autowired
    private MinioClient minioClient;

    public void run(String ... args) throws Exception {
        log.info("\u5f00\u59cb\u521d\u59cb\u5316\u5b58\u50a8\u6876");
        String sysBucket = this.minioProp.getSysBucket();
        String expertBucket = this.minioProp.getExpertBucket();
        String teacherBucket = this.minioProp.getTeacherBucket();
        String studentBucket = this.minioProp.getStudentBucket();
        String schoolShuxueBucket = this.minioProp.getShuxueBucket();
        List<String> buckets = Arrays.asList(sysBucket, expertBucket, teacherBucket, studentBucket, schoolShuxueBucket);
        buckets.forEach(bucketName -> {
            try {
                boolean b = this.minioClient.bucketExists(bucketName);
                if (!b) {
                    this.minioClient.makeBucket(bucketName);
                    String policy = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"*\"]},\"Action\":[\"s3:ListBucket\",\"s3:ListBucketMultipartUploads\",\"s3:GetBucketLocation\"],\"Resource\":[\"arn:aws:s3:::" + bucketName + "\"]},{\"Effect\":\"Allow\",\"Principal\":{\"AWS\":[\"*\"]},\"Action\":[\"s3:PutObject\",\"s3:AbortMultipartUpload\",\"s3:DeleteObject\",\"s3:GetObject\",\"s3:ListMultipartUploadParts\"],\"Resource\":[\"arn:aws:s3:::" + bucketName + "/*\"]}]}";
                    this.minioClient.setBucketPolicy(bucketName, policy);
                } else {
                    System.out.println(bucketName + " already exists");
                }
            }
            catch (Exception e) {
                log.info("\u5931\u8d25\uff1a" + bucketName);
                e.printStackTrace();
            }
        });
    }
}

