/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.config;

import java.util.HashMap;
import org.apache.kafka.common.serialization.StringSerializer;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;

@Configuration
public class KafkaProducerConfig {
    @Value(value="${kafka.bootstrap.server}")
    private String bootStrapServer;
    @Value(value="${kafka.zsy.sasl.username}")
    private String saslUserName;
    @Value(value="${kafka.zsy.sasl.password}")
    private String saslPassword;

    @Bean
    public ProducerFactory<String, String> producerFactory() {
        HashMap<String, Object> configProps = new HashMap<String, Object>();
        configProps.put("bootstrap.servers", this.bootStrapServer);
        configProps.put("key.serializer", StringSerializer.class);
        configProps.put("value.serializer", StringSerializer.class);
        configProps.put("acks", "all");
        configProps.put("security.protocol", "SASL_PLAINTEXT");
        configProps.put("sasl.mechanism", "PLAIN");
        configProps.put("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"%s\" password=\"%s\";".formatted(this.saslUserName, this.saslPassword));
        return new DefaultKafkaProducerFactory(configProps);
    }

    @Bean
    public KafkaTemplate<String, String> kafkaTemplate() {
        KafkaTemplate template = new KafkaTemplate(this.producerFactory());
        return template;
    }
}

