/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.config;

import io.minio.MinioClient;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import io.minio.errors.InvalidResponseException;
import io.minio.errors.RegionConflictException;
import io.minio.errors.XmlParserException;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class MinioConfig {
    @Value(value="${minio.url}")
    private String url;
    @Value(value="${minio.port:9000}")
    private Integer port;
    @Value(value="${minio.accesskey}")
    private String accesskey;
    @Value(value="${minio.accessSecret}")
    private String accessSecret;

    @Bean
    public MinioClient minioClient() throws InvalidPortException, InvalidEndpointException, InvalidBucketNameException, InsufficientDataException, ErrorResponseException, IOException, NoSuchAlgorithmException, InvalidKeyException, InvalidResponseException, XmlParserException, InternalException, RegionConflictException {
        Boolean ssl = false;
        if (this.url.startsWith("https://")) {
            ssl = true;
        }
        MinioClient minioClient = new MinioClient(this.url, this.port.intValue(), this.accesskey, this.accessSecret, null, ssl.booleanValue());
        return minioClient;
    }
}

