/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.config;

import com.zsy.exam.common.result.Result;
import com.zsy.exam.filter.VerifyTokenFilter;
import com.zsy.exam.util.ResponseUtil;
import jakarta.annotation.Resource;
import jakarta.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.authentication.configuration.AuthenticationConfiguration;
import org.springframework.security.config.annotation.method.configuration.EnableMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityCustomizer;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableMethodSecurity
public class SecurityConfig {
    @Resource
    private ResponseUtil responseUtil;
    @Resource
    private VerifyTokenFilter verifyTokenFilter;

    @Bean
    public SecurityFilterChain securityFilterChain(HttpSecurity http) throws Exception {
        http.authorizeHttpRequests(request -> {
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)request.requestMatchers(new String[]{"/api/auths/**"})).permitAll();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)request.requestMatchers(new String[]{"/api/auths/logout"})).authenticated();
            ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)request.anyRequest()).authenticated();
        });
        http.formLogin(AbstractHttpConfigurer::disable);
        http.exceptionHandling(exceptionHandling -> exceptionHandling.accessDeniedHandler((request, response, accessDeniedException) -> this.responseUtil.response(response, Result.failed((String)"\u4f60\u6ca1\u6709\u8be5\u8d44\u6e90\u7684\u8bbf\u95ee\u6743\u9650"))));
        http.addFilterBefore((Filter)this.verifyTokenFilter, UsernamePasswordAuthenticationFilter.class);
        http.csrf(AbstractHttpConfigurer::disable);
        return (SecurityFilterChain)http.build();
    }

    @Bean
    public WebSecurityCustomizer webSecurityCustomizer() {
        String[] strings = VerifyTokenFilter.exclusionUrl.toArray(new String[0]);
        return web -> ((WebSecurity.IgnoredRequestConfigurer)web.ignoring().requestMatchers(new String[]{"/webjars/**", "/doc.html", "/swagger-resources/**", "/v3/api-docs/**", "/swagger-ui/**", "/swagger-ui.html", "/ws/**", "/ws-app/**"})).requestMatchers(strings);
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    public AuthenticationManager authenticationManager(AuthenticationConfiguration authenticationConfiguration) throws Exception {
        return authenticationConfiguration.getAuthenticationManager();
    }
}

