/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.AddressChannel;
import com.zsy.exam.service.IAddressChannelService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="address-channel", description="\u5feb\u901f\u901a\u9053")
@RequestMapping(value={"/api/address-channel"})
public class AddressChannelController {
    @Autowired
    private IAddressChannelService addressChannelService;

    @GetMapping(value={"/page"})
    @Operation(summary="\u5feb\u901f\u901a\u9053\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('address-channel-page')")
    public Result<Page<AddressChannel>> getAllAddressChannel(Page page) {
        Page addressChannelList = this.addressChannelService.getAllAddressChannel(page);
        return Result.success((Object)addressChannelList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u5feb\u901f\u901a\u9053\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('address-channel-add')")
    public Result add(@Valid @RequestBody AddressChannel addressChannel) {
        this.addressChannelService.add(addressChannel);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u5feb\u901f\u901a\u9053\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('address-channel-update')")
    public Result<Integer> update(@Valid @RequestBody AddressChannel addressChannel) {
        Integer num = this.addressChannelService.modify(addressChannel);
        return Result.success((Object)num);
    }

    @GetMapping(value={"/delete"})
    @Operation(summary="\u5feb\u901f\u901a\u9053\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('address-channel-delete')")
    public Result remove(@NotBlank(message="{required}") @NotBlank(message="{required}") String ids) {
        this.addressChannelService.remove(ids);
        return Result.success();
    }
}

