/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.vo.analysis.AnalysisClbumDetailVO;
import com.zsy.exam.model.vo.analysis.AnalysisClbumVO;
import com.zsy.exam.model.vo.analysis.AnalysisExamVO;
import com.zsy.exam.model.vo.analysis.AnalysisGradeVO;
import com.zsy.exam.model.vo.analysis.AnalysisSpecVO;
import com.zsy.exam.service.IAnalysisExamService;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/analysis"})
@Tag(name="\u8003\u8bd5\u5206\u6790\u56db\u5f20\u5377", description="\u8003\u8bd5\u5206\u6790\u56db\u5f20\u5377")
public class AnalysisExamController {
    @Autowired
    private IAnalysisExamService analysisExamService;

    @GetMapping(value={"/subject"})
    public Result<AnalysisExamVO> getSubjectDetail(Long examId) {
        AnalysisExamVO vo = this.analysisExamService.getAnalysisExamSubject(examId);
        return Result.success((Object)vo);
    }

    @GetMapping(value={"/spec"})
    public Result<AnalysisSpecVO> getSpecDetail(Long examId) {
        AnalysisSpecVO analysisExamSpec = this.analysisExamService.getAnalysisExamSpec(examId);
        return Result.success((Object)analysisExamSpec);
    }

    @GetMapping(value={"/grade"})
    public Result<List<AnalysisGradeVO>> getGradeDetail(Long examAreaId) {
        List gradeDetail = this.analysisExamService.getGradeDetail(examAreaId);
        return Result.success((Object)gradeDetail);
    }

    @GetMapping(value={"/clbum"})
    public Result<List<AnalysisClbumVO>> getClbumDetail(Long examAreaId, Long clbumId) {
        List clbumDetail = this.analysisExamService.getClbumDetail(examAreaId, clbumId);
        return Result.success((Object)clbumDetail);
    }

    @GetMapping(value={"/clbum/student"})
    public Result<List<AnalysisClbumDetailVO>> getClbumStudentDetail(Long examAreaId, Long clbumId) {
        List clbumDetail = this.analysisExamService.getClbumStudentDetail(examAreaId, clbumId);
        return Result.success((Object)clbumDetail);
    }
}

