/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.group.AnswerGroup;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.form.answer.CorrectAnswerFrom;
import com.zsy.exam.model.vo.answer.AnswerExamVO;
import com.zsy.exam.model.vo.answer.ProgressAnalysisVO;
import com.zsy.exam.model.vo.answer.ProgressDetailsVO;
import com.zsy.exam.model.vo.answer.UncorrectedUserVO;
import com.zsy.exam.model.vo.exam.ExamQuCollectVO;
import com.zsy.exam.service.IExamService;
import com.zsy.exam.service.IManualScoreService;
import com.zsy.exam.util.SecurityUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/answers"})
@Tag(name="\u9605\u5377\u7ba1\u7406", description="\u9605\u5377\u7ba1\u7406")
public class AnswerController {
    @Resource
    private IManualScoreService manualScoreService;
    @Resource
    private IExamService examService;

    @GetMapping(value={"/detail"})
    @PreAuthorize(value="hasAnyAuthority('answers-detail')")
    @Operation(summary="\u8bd5\u5377\u67e5\u8be2\u4fe1\u606f(\u8003\u8bd5\u53cd\u663e\u540c\u4e00\u63a5\u53e3)")
    public Result<List<ExamQuCollectVO>> getDetail(@RequestParam Long userId, @RequestParam Long examId, @RequestParam(required=false) Boolean onlySubjective) {
        return this.examService.getCollect0(examId, null, userId, onlySubjective);
    }

    @PutMapping(value={"/correct"})
    @PreAuthorize(value="hasAnyAuthority('answers-correct')")
    @Operation(summary="\u6279\u6539\u8bd5\u5377")
    public Result<String> Correct(@RequestBody @Validated(value={AnswerGroup.CorrectGroup.class}) List<CorrectAnswerFrom> correctAnswerFroms) {
        return this.manualScoreService.correct(correctAnswerFroms);
    }

    @GetMapping(value={"/exam/page"})
    @PreAuthorize(value="hasAnyAuthority('answers-exam-page')")
    @Operation(summary="\u5206\u9875\u67e5\u627e\u5f85\u9605\u5377\u8003\u8bd5")
    public Result<IPage<AnswerExamVO>> examPage(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="examName", required=false) String examName) {
        return this.manualScoreService.examPage(pageNum, pageSize, examName);
    }

    @GetMapping(value={"/exam/stu"})
    @PreAuthorize(value="hasAnyAuthority('answers-exam-stu')")
    @Operation(summary="\u67e5\u8be2\u5f85\u6279\u9605\u7684\u7528\u6237")
    public Result<IPage<UncorrectedUserVO>> stuExamPage(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="examId") Long examId, @RequestParam(value="realName", required=false) String realName, @RequestParam(value="isAttend", required=false) Integer isAttend, @RequestParam(value="whetherMark", required=false) Integer whetherMark) {
        return this.manualScoreService.stuExamPage(pageNum, pageSize, examId, realName, isAttend, whetherMark);
    }

    @GetMapping(value={"/progress/analysis"})
    @PreAuthorize(value="hasAnyAuthority('answers-progress-analysis')")
    @Operation(summary="\u9605\u5377\u8fdb\u5ea6 - \u9605\u5377\u7edf\u8ba1")
    public Result<IPage<ProgressAnalysisVO>> CorrectProgressAnalysis(Page page, @RequestParam(value="examId") Long examId, @RequestParam(value="teacherName", required=false) String teacherName) {
        Long userId = SecurityUtil.getUserId();
        return this.manualScoreService.correctProgressAnalysis(page, examId, userId, teacherName);
    }

    @GetMapping(value={"/progress/details"})
    @PreAuthorize(value="hasAnyAuthority('answers-progress-details')")
    @Operation(summary="\u9605\u5377\u8fdb\u5ea6 - \u9605\u5377\u8bb0\u5f55")
    public Result<IPage<ProgressDetailsVO>> CorrectProgressDetails(Page page, @RequestParam(value="examId") Long examId, @RequestParam(value="studentName", required=false) String studentName, @RequestParam(value="teacherName", required=false) String teacherName) {
        Long userId = SecurityUtil.getUserId();
        return this.manualScoreService.correctProgressDetails(page, examId, userId, studentName, teacherName);
    }
}

