/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.zsy.exam.common.group.UserGroup;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.form.Auth.LoginForm;
import com.zsy.exam.model.form.UserForm;
import com.zsy.exam.service.IAuthService;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/auths"})
public class AuthController {
    @Resource
    private IAuthService iAuthService;

    @PostMapping(value={"/login"})
    public Result<Map> login(HttpServletRequest request, HttpServletResponse response, @Validated @RequestBody LoginForm loginForm) {
        return this.iAuthService.login(request, response, loginForm);
    }

    @DeleteMapping(value={"/logout"})
    public Result<String> logout(HttpServletRequest request) {
        return this.iAuthService.logout(request);
    }

    @PostMapping(value={"/register"})
    public Result<String> register(HttpServletRequest request, @RequestBody @Validated(value={UserGroup.RegisterGroup.class}) UserForm userForm) {
        return this.iAuthService.register(request, userForm);
    }

    @GetMapping(value={"/captcha"})
    public Result<Map> getCaptcha(HttpServletRequest request, HttpServletResponse response) {
        return this.iAuthService.getCaptcha(request, response);
    }

    @GetMapping(value={"/verifyCode/{code}"})
    public Result<String> verifyCode(HttpServletRequest request, @PathVariable(value="code") String code) {
        return this.iAuthService.verifyCode(request, code);
    }
}

