/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.Catalogue;
import com.zsy.exam.model.vo.CatalogueSimpleVO;
import com.zsy.exam.service.ICatalogueService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/catalogue"})
public class CatalogueController {
    @Autowired
    private ICatalogueService catalogueService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="Catalogue\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('catalogue-selectOne')")
    public Result<Catalogue> getCatalogue(@RequestParam(value="id") Long id) {
        Catalogue catalogueOne = this.catalogueService.getCatalogue(id);
        return Result.ok((Object)catalogueOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="Catalogue\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('catalogue-listAll')")
    public Result<List<Catalogue>> getAllCatalogue() {
        List catalogueList = this.catalogueService.getAllCatalogue();
        return Result.ok((Object)catalogueList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="Catalogue\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('catalogue-add')")
    @SysLog(title="\u9898\u76ee\u76ee\u5f55\u65b0\u589e", businessType=BusinessType.INSERT)
    public Result add(@Valid @RequestBody Catalogue catalogue) {
        this.catalogueService.add(catalogue, Boolean.TRUE);
        return Result.ok();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="Catalogue\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('catalogue-update')")
    @SysLog(title="\u9898\u76ee\u76ee\u5f55\u4fee\u6539", businessType=BusinessType.UPDATE)
    public Result update(@Valid @RequestBody Catalogue catalogue) {
        this.catalogueService.modify(catalogue);
        return Result.ok();
    }

    @PostMapping(value={"importExcel"})
    @SysLog(title="\u5bfc\u5165\u77e5\u8bc6\u70b9", businessType=BusinessType.IMPORT)
    @PreAuthorize(value="hasAnyAuthority('catalogue-importExcel')")
    public Result importExcel(@RequestParam(value="file") MultipartFile file) {
        return Result.success((String)this.catalogueService.importExcel(file));
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="Catalogue\u5220\u9664(\u5355\u4e2a\u6761\u76ee)")
    @PreAuthorize(value="hasAnyAuthority('catalogue-delete')")
    @SysLog(title="\u9898\u76ee\u76ee\u5f55\u5220\u9664", businessType=BusinessType.DELETE)
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.catalogueService.remove(ids);
        return Result.ok();
    }

    @GetMapping(value={"/tree/{type}"})
    @Operation(summary="\u76ee\u5f55\u6811")
    @PreAuthorize(value="hasAnyAuthority('catalogue-tree')")
    public Result getDataTreePage(@PathVariable String type, String pathCode, Boolean demo) {
        return Result.success((Object)this.catalogueService.getTree(type, pathCode, demo));
    }

    @GetMapping(value={"/check-exists"})
    @Operation(summary="\u6821\u9a8c\u662f\u5426\u5b58\u5728")
    @PreAuthorize(value="hasAnyAuthority('catalogue-check-exists')")
    public Result<List<CatalogueSimpleVO>> getByNameAndLevel(String name, Integer level, String pathCode) {
        return Result.success((Object)this.catalogueService.getByNameAndLevel(name, level, pathCode));
    }
}

