/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.Clbum;
import com.zsy.exam.model.form.ClbumForm;
import com.zsy.exam.model.vo.ClbumTreeVO;
import com.zsy.exam.model.vo.ClbumVO;
import com.zsy.exam.service.IClbumService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import java.util.List;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/clbum"})
@Tag(name="clbum", description="\u73ed\u7ea7\u7ba1\u7406")
public class ClbumController {
    @Resource
    private IClbumService clbumService;

    @GetMapping(value={"/paging"})
    @PreAuthorize(value="hasAnyAuthority('clbum-paging')")
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u73ed\u7ea7")
    public Result<Page<ClbumVO>> getClbum(Page page, @RequestParam(value="clbumName", required=false) String clbumName, @RequestParam(value="specialtyId", required=false) Long specialtyId, @RequestParam(value="gradeId", required=false) Long gradeId) {
        return this.clbumService.getPaging(page, clbumName, gradeId, specialtyId);
    }

    @PostMapping(value={"/add"})
    @PreAuthorize(value="hasAnyAuthority('clbum-add')")
    @Operation(summary="\u65b0\u589e\u73ed\u7ea7")
    @SysLog(title="\u65b0\u589e\u73ed\u7ea7", businessType=BusinessType.INSERT)
    public Result<String> addClbum(@Validated @RequestBody ClbumForm clbumForm) {
        this.clbumService.addClbum(clbumForm);
        return Result.success((String)"\u6dfb\u52a0\u6210\u529f");
    }

    @PutMapping(value={"/update/{id}"})
    @PreAuthorize(value="hasAnyAuthority('clbum-update')")
    @Operation(summary="\u4fee\u6539\u73ed\u7ea7")
    @SysLog(title="\u4fee\u6539\u73ed\u7ea7", businessType=BusinessType.UPDATE)
    public Result<String> updateClbum(@PathVariable(value="id") @NotNull Long id, @Validated @RequestBody ClbumForm clbumForm) {
        return this.clbumService.updateClbum(id, clbumForm);
    }

    @DeleteMapping(value={"/delete"})
    @PreAuthorize(value="hasAnyAuthority('clbum-delete')")
    @Operation(summary="\u6279\u91cf\u5220\u9664\u73ed\u7ea7")
    @SysLog(title="\u6279\u91cf\u5220\u9664\u73ed\u7ea7", businessType=BusinessType.DELETE)
    public Result<String> deleteClbum(@RequestBody @NotNull List<Long> ids) {
        return this.clbumService.deleteClbum(ids);
    }

    @PatchMapping(value={"/remove/{ids}"})
    @PreAuthorize(value="hasAnyAuthority('clbum-remove')")
    @Operation(summary="\u7528\u6237\u9000\u51fa\u73ed\u7ea7")
    public Result<String> removeUserClbum(@PathVariable(value="ids") @NotBlank String ids) {
        return this.clbumService.removeUserClbum(ids);
    }

    @GetMapping(value={"/list"})
    @PreAuthorize(value="hasAnyAuthority('clbum-list')")
    @Operation(summary="\u83b7\u53d6\u6240\u6709\u73ed\u7ea7\u5217\u8868")
    public Result<List<ClbumVO>> getAllClbum() {
        return this.clbumService.getAllClbum();
    }

    @GetMapping(value={"/list/tree"})
    @PreAuthorize(value="hasAnyAuthority('clbum-list')")
    @Operation(summary="\u83b7\u53d6\u6240\u6709\u73ed\u7ea7\u3001\u4e13\u4e1a\u3001\u5e74\u7ea7\u5217\u8868\u6811")
    public Result<List<ClbumTreeVO>> getAllClbumTree(@RequestParam(value="clbumId", required=false) Long clbumId, @RequestParam(value="specialtyId", required=false) Long specialtyId, @RequestParam(value="gradeId", required=false) Long gradeId) {
        return this.clbumService.getAllClbumTree(clbumId, specialtyId, gradeId);
    }

    @GetMapping(value={"/list/tree/exam"})
    @PreAuthorize(value="hasAnyAuthority('clbum-list')")
    @Operation(summary="\u6839\u636e\u8003\u8bd5\uff0c\u83b7\u53d6\u53c2\u4e0e\u7684\u6240\u6709\u73ed\u7ea7\u3001\u4e13\u4e1a\u3001\u5e74\u7ea7\u5217\u8868\u6811")
    public Result<List<ClbumTreeVO>> getAllClbumTreeForExam(@RequestParam(value="examId", required=true) Long examId, @RequestParam(value="clbumId", required=false) Long clbumId, @RequestParam(value="specialtyId", required=false) Long specialtyId, @RequestParam(value="gradeId", required=false) Long gradeId) {
        return this.clbumService.getAllClbumTreeForExam(examId, clbumId, specialtyId, gradeId);
    }

    @GetMapping(value={"/specialty/list/{specialtyId}"})
    @PreAuthorize(value="hasAnyAuthority('clbum-specialty-list')")
    @Operation(summary="\u83b7\u53d6\u6240\u6709\u8be5\u4e13\u4e1a\u73ed\u7ea7\u5217\u8868")
    public Result<List<Clbum>> getAllClbumFromSpecialty(@PathVariable(value="specialtyId") Long specialtyId) {
        return this.clbumService.getAllClbumFromSpecialty(specialtyId);
    }

    @GetMapping(value={"/grade/list/{gradeId}"})
    @PreAuthorize(value="hasAnyAuthority('clbum-grade-list')")
    @Operation(summary="\u83b7\u53d6\u6240\u6709\u8be5\u5e74\u7ea7\u73ed\u7ea7\u5217\u8868")
    public Result<List<Clbum>> getAllClbumFromGrade(@PathVariable(value="gradeId") Long gradeId) {
        return this.clbumService.getAllClbumFromGrade(gradeId);
    }

    @GetMapping(value={"/specialty/grade/list"})
    @PreAuthorize(value="hasAnyAuthority('clbum-specialty-grade-list')")
    @Operation(summary="\u83b7\u53d6\u6240\u6709\u8be5\u4e13\u4e1a\u3001\u5e74\u7ea7\u73ed\u7ea7\u5217\u8868")
    public Result<List<Clbum>> getAllClbumFromSpecialty(@RequestParam(value="specialtyId") Long specialtyId, @RequestParam(value="gradeId") Long gradeId) {
        return this.clbumService.getAllClbumFromSpecialtyAndgradeId(specialtyId, gradeId);
    }

    @GetMapping(value={"/listByNotTeacher"})
    @PreAuthorize(value="hasAnyAuthority('clbum-listByNotTeacher')")
    @Operation(summary="\u83b7\u53d6\u6240\u6709\u7684\u672a\u542b\u6709\u73ed\u4e3b\u4efb\u7684\u73ed\u7ea7")
    public Result<List<Clbum>> listByNotTeacher(Long userId) {
        return Result.success((Object)this.clbumService.listByNotTeacher(userId));
    }

    @PostMapping(value={"importClbum"})
    @PreAuthorize(value="hasAnyAuthority('clbum-importClbum')")
    @SysLog(title="\u5bfc\u5165\u73ed\u7ea7", businessType=BusinessType.IMPORT)
    public Result importSpecialty(@RequestParam(value="file") MultipartFile file) throws Exception {
        this.clbumService.importClbum(file);
        return Result.success();
    }

    @GetMapping(value={"exportClbum"})
    @PreAuthorize(value="hasAnyAuthority('clbum-exportClbum')")
    public Result exportSpecialty(HttpServletResponse response, String clbumName) {
        this.clbumService.exportClbum(response, clbumName);
        return Result.success();
    }

    @GetMapping(value={"exportClbumTemp"})
    public Result exportClbumTemp(HttpServletResponse response) {
        this.clbumService.exportClbumTemp(response);
        return Result.success();
    }
}

