/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.EmailManagerDTO;
import com.zsy.exam.model.vo.EmailManangerVO;
import com.zsy.exam.service.IEmailManagerService;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="email-manager", description="\u90ae\u7bb1\u7ba1\u7406")
@RequestMapping(value={"/api/email-manager"})
public class EmailManagerController {
    @Autowired
    private IEmailManagerService emailManagerService;

    @RequestMapping(value={"/get"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasAnyAuthority('email-manager-get')")
    public Result<EmailManangerVO> get() {
        return Result.ok((Object)this.emailManagerService.get());
    }

    @RequestMapping(value={"/addOrUpdate"}, method={RequestMethod.POST})
    @SysLog(title="\u65b0\u589e\uff0c\u4fee\u6539\u90ae\u7bb1\u7ba1\u7406", businessType=BusinessType.INSERT)
    @PreAuthorize(value="hasAnyAuthority('email-manager-addOrUpdate')")
    public Result addOrUpdate(@RequestBody EmailManagerDTO dto) {
        this.emailManagerService.addOrUpdate(dto);
        return Result.ok();
    }
}

