/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.ExamAreaDTO;
import com.zsy.exam.model.vo.ExamAreaVO;
import com.zsy.exam.service.IExamAreaService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="exam-area", description="\u533a\u57df\u8003\u8bd5")
@RequestMapping(value={"/api/exam-area"})
public class ExamAreaController {
    @Autowired
    private IExamAreaService examAreaService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u533a\u57df\u8003\u8bd5\u67e5\u8be2\u5355\u4e2a")
    public Result<ExamAreaVO> getExamArea(@RequestParam(value="id") Long id) {
        ExamAreaVO examAreaOne = this.examAreaService.getExamArea(id);
        return Result.success((Object)examAreaOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u533a\u57df\u8003\u8bd5\u67e5\u8be2\u5168\u90e8")
    public Result<Page<ExamAreaVO>> getAllExamArea(Page page, String name) {
        Page examAreaList = this.examAreaService.getAllExamArea(page, name);
        return Result.success((Object)examAreaList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u533a\u57df\u8003\u8bd5\u65b0\u589e")
    public Result add(@Valid @RequestBody ExamAreaDTO examArea) {
        this.examAreaService.add(examArea);
        return Result.success();
    }

    @PostMapping(value={"/update"})
    @Operation(summary="\u533a\u57df\u8003\u8bd5\u4fee\u6539")
    public Result update(@Valid @RequestBody ExamAreaDTO examArea) {
        this.examAreaService.modify(examArea);
        return Result.success();
    }

    @GetMapping(value={"/delete"})
    @Operation(summary="\u533a\u57df\u8003\u8bd5\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    public Result remove(String ids) {
        this.examAreaService.remove(ids);
        return Result.success();
    }
}

