/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.ExamClbum;
import com.zsy.exam.model.entity.ExamClbumExtreme;
import com.zsy.exam.service.IExamClbumService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="\u8003\u8bd5\u73ed\u7ea7\u6620\u5c04", description="")
@RequestMapping(value={"/api/exam-clbum"})
public class ExamClbumController {
    @Autowired
    private IExamClbumService examClbumService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('exam-clbum-selectOne')")
    public Result<ExamClbum> getExamClbum(@RequestParam(value="id") Long id) {
        ExamClbum examClbumOne = this.examClbumService.getExamClbum(id);
        return Result.success((Object)examClbumOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('exam-clbum-listAll')")
    public Result<Page<ExamClbum>> getAllExamClbum(Page page) {
        Page examClbumList = this.examClbumService.getAllExamClbum(page);
        return Result.success((Object)examClbumList);
    }

    @GetMapping(value={"/listClbumFromExam"})
    @Operation(summary="\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('exam-clbum-listClbumFromExam')")
    public Result<List<ExamClbumExtreme>> listClbumFromExam(Long id) {
        List examClbumList = this.examClbumService.listClbumFromExam(id);
        return Result.success((Object)examClbumList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('exam-clbum-add')")
    public Result add(@Valid @RequestBody ExamClbum examClbum) {
        this.examClbumService.add(examClbum);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('exam-clbum-update')")
    public Result<Integer> update(@Valid @RequestBody ExamClbum examClbum) {
        Integer num = this.examClbumService.modify(examClbum);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('exam-clbum-update-delete')")
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.examClbumService.remove(ids);
        return Result.success();
    }
}

