/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.Exam;
import com.zsy.exam.model.entity.OngoingExam;
import com.zsy.exam.model.form.exam.ExamAddForm;
import com.zsy.exam.model.form.examquanswer.ExamQuAnswerAddForm;
import com.zsy.exam.model.vo.Key2ValueVo;
import com.zsy.exam.model.vo.exam.AnalyseIntroduceVo;
import com.zsy.exam.model.vo.exam.ExamClbumListVO;
import com.zsy.exam.model.vo.exam.ExamDetailVO;
import com.zsy.exam.model.vo.exam.ExamHandSimpleReportVO;
import com.zsy.exam.model.vo.exam.ExamQuCollectVO;
import com.zsy.exam.model.vo.exam.ExamQuDetailVO;
import com.zsy.exam.model.vo.exam.ExamQuestionListVO;
import com.zsy.exam.model.vo.exam.ExamVO;
import com.zsy.exam.model.vo.exam.MyExamDetailVO;
import com.zsy.exam.model.vo.exam.MyExamListVO;
import com.zsy.exam.model.vo.exam.StudentRankVo;
import com.zsy.exam.service.IExamService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.util.List;
import java.util.Map;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/exams"})
@Tag(name="\u8003\u8bd5\u7ba1\u7406", description="\u8003\u8bd5\u7ba1\u7406")
public class ExamController {
    @Resource
    private IExamService examService;
    @Resource
    private StringRedisTemplate stringRedisTemplate;

    @PostMapping
    @PreAuthorize(value="hasAnyAuthority('exams-add')")
    @Operation(summary="\u521b\u5efa\u8003\u8bd5")
    @SysLog(title="\u521b\u5efa\u8003\u8bd5", businessType=BusinessType.INSERT)
    public Result<String> createExam(@Validated @RequestBody ExamAddForm examAddForm) {
        return this.examService.createExam(examAddForm);
    }

    @GetMapping(value={"/start"})
    @PreAuthorize(value="hasAnyAuthority('exams-start')")
    @Operation(summary="\u5f00\u59cb\u8003\u8bd5")
    public Result<String> startExam(@RequestParam(value="examId") @NotNull Long examId) {
        return this.examService.startExam(examId);
    }

    @PutMapping(value={""})
    @PreAuthorize(value="hasAnyAuthority('exams-update')")
    @Operation(summary="\u4fee\u6539\u8003\u8bd5")
    @SysLog(title="\u4fee\u6539\u8003\u8bd5", businessType=BusinessType.UPDATE)
    public Result<String> updateExam(@Validated @RequestBody Exam exam) {
        return this.examService.updateExam(exam);
    }

    @DeleteMapping(value={"/{ids}"})
    @PreAuthorize(value="hasAnyAuthority('exams-delete')")
    @Operation(summary="\u5220\u9664\u8003\u8bd5")
    @SysLog(title="\u5220\u9664\u8003\u8bd5", businessType=BusinessType.DELETE)
    public Result<String> deleteExam(@PathVariable(value="ids") @Pattern(regexp="^\\d+(,\\d+)*$|^\\d+$") @Pattern(regexp="^\\d+(,\\d+)*$|^\\d+$") String ids) {
        return this.examService.deleteExam(ids);
    }

    @GetMapping(value={"/paging"})
    @PreAuthorize(value="hasAnyAuthority('exams-paging')")
    @Operation(summary="\u6559\u5e08\u5206\u9875\u67e5\u627e\u8003\u8bd5\u5217\u8868")
    public Result<IPage<ExamVO>> getPagingExam(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="title", required=false) String title, @RequestParam(value="subjectId", required=false) Long subjectId, @RequestParam(value="examStartDate", required=false) String examStartDate, @RequestParam(value="examEndDate", required=false) String examEndDate) {
        return this.examService.getPagingExam(pageNum, pageSize, title, subjectId, examStartDate, examEndDate);
    }

    @GetMapping(value={"/question/list/{examId}"})
    @PreAuthorize(value="hasAnyAuthority('exams-question-list')")
    @Operation(summary="\u83b7\u53d6\u8003\u8bd5\u9898\u76ee\u5217\u8868")
    public Result<ExamQuestionListVO> getQuestionList(@PathVariable(value="examId") @NotBlank Long examId) {
        return this.examService.getQuestionList(examId);
    }

    @GetMapping(value={"/question/single"})
    @PreAuthorize(value="hasAnyAuthority('exams-question-single')")
    @Operation(summary="\u83b7\u53d6\u5355\u9898\u4fe1\u606f(\u5e9f\u5f03)")
    public Result<ExamQuDetailVO> getQuestionSingle(@RequestParam(value="examId") Long examId, @RequestParam(value="questionId") Long questionId) {
        return this.examService.getQuestionSingle(examId, questionId);
    }

    @GetMapping(value={"/question/single/list"})
    @PreAuthorize(value="hasAnyAuthority('exams-question-single-list')")
    @Operation(summary="\u6279\u91cf\u83b7\u53d6\u5355\u9898\u4fe1\u606f\uff08\u5305\u542b\u7528\u6237\u7b54\u9898\u4fe1\u606f\u56de\u663e\uff09")
    public Result<List<ExamQuDetailVO>> getQuestionSingleList(@RequestParam(value="examId") Long examId) {
        Result res = this.examService.getQuestionSingleList(examId);
        return res;
    }

    @GetMapping(value={"/collect"})
    @PreAuthorize(value="hasAnyAuthority('exams-collect')")
    @Operation(summary="\u8003\u8bd5\u7ed3\u675f\u540e\u83b7\u53d6\u6240\u6709\u9898\u76ee\u6c47\u603b(\u53cd\u663e) isRight=0\u9519\u8bef 1\u6b63\u786e")
    public Result<List<ExamQuCollectVO>> getCollect(@RequestParam(value="examId") @NotNull Long examId, @RequestParam(value="isRight", required=false) Integer isRight) {
        return this.examService.getCollect(examId, isRight);
    }

    @GetMapping(value={"/detail"})
    @PreAuthorize(value="hasAnyAuthority('exams-detail')")
    @Operation(summary="\u83b7\u53d6\u8003\u8bd5\u8be6\u60c5\u4fe1\u606f")
    public Result<ExamDetailVO> getDetail(@RequestParam(value="examId") @NotBlank Long examId) {
        return this.examService.getDetail(examId);
    }

    @GetMapping(value={"/clbum"})
    @PreAuthorize(value="hasAnyAuthority('exams-clbum')")
    @Operation(summary="\u6839\u636e\u73ed\u7ea7\u83b7\u5f97\u8003\u8bd5(\u5e9f\u5f03)")
    public Result<IPage<ExamClbumListVO>> getClbumExamList(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="title", required=false) String title) {
        return this.examService.getClbumExamList(pageNum, pageSize, title);
    }

    @PutMapping(value={"/cheat/{examId}"})
    @PreAuthorize(value="hasAnyAuthority('exams-cheat')")
    @Operation(summary="\u8003\u8bd5\u4f5c\u5f0a\u6b21\u6570\u6dfb\u52a0\uff08\u7b54\u5377\u6b21\u6570\uff09")
    public Result<Integer> addCheat(@PathVariable(value="examId") @NotNull Long examId) {
        return this.examService.addCheat(examId);
    }

    @GetMapping(value={"/ischeat"})
    @PreAuthorize(value="hasAnyAuthority('exams-cheat')")
    @Operation(summary="\u662f\u5426\u4f5c\u5f0a\u8005")
    public Result<Boolean> isCheat(@RequestParam(value="examId") @NotNull Long examId) {
        return this.examService.isCheat(examId);
    }

    @PostMapping(value={"/full-answer"})
    @PreAuthorize(value="hasAnyAuthority('exams-full-answer')")
    @Operation(summary="\u586b\u5145\u7b54\u6848(\u5355\u9898\u7b54\u9898)")
    @SysLog(title="\u8003\u8bd5\u586b\u5145\u7b54\u6848", businessType=BusinessType.OTHER)
    public Result<String> addAnswer(@Validated @RequestBody ExamQuAnswerAddForm examQuAnswerForm) {
        return this.examService.addAnswer(examQuAnswerForm);
    }

    @GetMapping(value={"/hand-exam/{examId}"})
    @PreAuthorize(value="hasAnyAuthority('exams-hand-exam')")
    @Operation(summary="\u4ea4\u5377\u64cd\u4f5c")
    @SysLog(title="\u8003\u8bd5\u4ea4\u5377\u64cd\u4f5c", businessType=BusinessType.OTHER)
    public Result<ExamHandSimpleReportVO> handleExam(@PathVariable(value="examId") @NotNull Long examId) {
        return this.examService.handExam(examId);
    }

    @GetMapping(value={"/my/exam-list"})
    @PreAuthorize(value="hasAnyAuthority('exams-my-exam-list')")
    @Operation(summary="\u67e5\u8be2\u81ea\u5df1\u7684\u8003\u8bd5\u8bb0\u5f55")
    public Result<IPage<MyExamListVO>> myExamHistory(Page page) {
        return this.examService.myExamList(page);
    }

    @GetMapping(value={"/my/exam"})
    @PreAuthorize(value="hasAnyAuthority('exams-my-exam')")
    @Operation(summary="\u67e5\u8be2\u81ea\u5df1\u7684\u8003\u8bd5\u8be6\u7ec6(\u8003\u8bd5\u5b8c\u6210\u540e\u56de\u663e)")
    public Result<MyExamDetailVO> myExamDetail(@RequestParam @NotNull Long examId) {
        return this.examService.myExamDetail(examId);
    }

    @GetMapping(value={"/ongoing/exam"})
    @PreAuthorize(value="hasAnyAuthority('exams-ongoing-exam')")
    @Operation(summary="\u67e5\u8be2\u81ea\u5df1\u6b63\u5728\u8fdb\u884c\u4e2d\u7684\u8003\u8bd5")
    public Result<IPage<OngoingExam>> myOngoingExamList(Page page) {
        return this.examService.myOngoingExamList(page);
    }

    @GetMapping(value={"/index"})
    @PreAuthorize(value="hasAnyAuthority('exams-index')")
    @Operation(summary="\u9996\u9875\u6570\u636e\u5206\u6790")
    public Result<Map<String, Object>> indexAnalyse() {
        return this.examService.indexAnalyse();
    }

    @GetMapping(value={"/region/monitor"})
    @Operation(summary="\u533a\u57df\u76d1\u8003\u6570\u636e\u5206\u6790\uff08\u533a\u57df\u7248\u5b66\u6821\u7aef\uff09")
    public Result<Map<String, Object>> examInfoMonitor(@RequestParam @NotNull Long examId) {
        return this.examService.examInfoMonitor(examId);
    }

    @GetMapping(value={"/region/screen"})
    @Operation(summary="\u533a\u57df\u76d1\u8003\u5927\u5c4f\uff08\u533a\u57df\u7248\u5b66\u6821\u7aef\uff09")
    public Result<Map<String, Object>> examInfoScreen(@RequestParam(required=true) String examDateTime) {
        return this.examService.examInfoScreen(examDateTime);
    }

    @PostMapping(value={"/region/push"})
    @Operation(summary="\u63a8\u9001\u8003\u8bd5\u6570\u636e\u5230\u8fdc\u7aef")
    public Result pushExamInfoToRemote(@RequestBody @NotNull List<Long> examIds) {
        return this.examService.pushToRemote(examIds);
    }

    @GetMapping(value={"/analyse/totalBySubject/{days}"})
    @PreAuthorize(value="hasAnyAuthority('exams-analyse-totalBySubject')")
    @Operation(summary="\u8003\u8bd5\u5206\u6790\u573a\u6b21\u6570,days \u8fd1x\u5929")
    public Result<List<Key2ValueVo>> totalBySubject(@PathVariable(value="days") Integer days, String subject) {
        return Result.ok((Object)this.examService.totalBySubject(days, subject));
    }

    @GetMapping(value={"/analyse/reportByClbum/{examId}"})
    @PreAuthorize(value="hasAnyAuthority('exams-analyse-reportByClbum')")
    @Operation(summary="\u8003\u8bd5\u62a5\u544a\u5206\u6790-\u6309\u73ed\u7ea7")
    public Result<List<Map<String, Object>>> reportByClbum(@PathVariable(value="examId") Long examId) {
        return Result.ok((Object)this.examService.reportByClbum(examId));
    }

    @GetMapping(value={"/analyse/reportBySpecialty/{examId}"})
    @PreAuthorize(value="hasAnyAuthority('exams-analyse-reportBySpecialty')")
    @Operation(summary="\u8003\u8bd5\u62a5\u544a\u5206\u6790-\u6309\u4e13\u4e1a")
    public Result<List<Map<String, Object>>> reportBySpecialty(@PathVariable(value="examId") Long examId) {
        return Result.ok((Object)this.examService.reportBySpecialty(examId));
    }

    @GetMapping(value={"/analyse/studentRankByClbum/{examId}/{clbumId}"})
    @PreAuthorize(value="hasAnyAuthority('exams-analyse-studentRankByClbum')")
    @Operation(summary="\u8003\u8bd5\u5206\u6790-\u5b66\u751f\u8003\u8bd5\u6392\u540d")
    public Result<List<StudentRankVo>> detailByClbumStudent(@PathVariable(value="examId") Long examId, @PathVariable(value="clbumId") Long clbumId) {
        return Result.ok((Object)this.examService.studentRankByClbum(examId, clbumId));
    }

    @GetMapping(value={"/analyse/analyseIntroduce/{examId}"})
    @PreAuthorize(value="hasAnyAuthority('exams-analyse-analyseIntroduce')")
    @Operation(summary="\u8003\u8bd5\u5206\u6790-\u8003\u8bd5\u4ecb\u7ecd\u77ed\u8bed")
    public Result<AnalyseIntroduceVo> analyseIntroduce(@PathVariable(value="examId") Long examId) {
        return Result.ok((Object)this.examService.analyseIntroduce(examId));
    }
}

