/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.ExamInfo;
import com.zsy.exam.model.entity.ExamInfoRankBySubject;
import com.zsy.exam.model.entity.ExamInfoRankBySubjectExport;
import com.zsy.exam.service.IExamInfoService;
import com.zsy.exam.util.excel.ExcelUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="exam-info", description="")
@RequestMapping(value={"/api/exam-info"})
public class ExamInfoController {
    @Autowired
    private IExamInfoService examInfoService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result<ExamInfo> getExamInfo(@RequestParam(value="id") Long id) {
        ExamInfo examInfoOne = this.examInfoService.getExamInfo(id);
        return Result.success((Object)examInfoOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result<Page<ExamInfo>> getAllExamInfo(Page page) {
        Page examInfoList = this.examInfoService.getAllExamInfo(page);
        return Result.success((Object)examInfoList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result add(@Valid @RequestBody ExamInfo examInfo) {
        this.examInfoService.add(examInfo);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result<Integer> update(@Valid @RequestBody ExamInfo examInfo) {
        Integer num = this.examInfoService.modify(examInfo);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.examInfoService.remove(ids);
        return Result.success();
    }

    @GetMapping(value={"/school/tree"})
    @Operation(summary="\u5b66\u6821\u7aef\u8003\u8bd5\u83dc\u5355\u6811\u67e5\u8be2")
    public Result<List<Map>> queryRemoteSchoolExamInfoMenuTree(@RequestParam(required=true) String examJobId, @RequestParam(required=false) String schoolCode) {
        return Result.ok((Object)this.examInfoService.queryRemoteSchoolExamInfoMenuTree(examJobId, schoolCode));
    }

    @GetMapping(value={"/subject/rank"})
    @Operation(summary="\u5b66\u6821\u7aef\u8003\u8bd5\u6570\u636e\u67e5\u8be2 \u6309\u7167\u79d1\u76ee")
    public Result<Page<ExamInfoRankBySubject>> getIndividuleDetailsBySubject(Page page, @RequestParam(required=true) String examJobId, @RequestParam(required=true) String schoolCode, @RequestParam(required=false) String subjectId, @RequestParam(required=false) String gardName, @RequestParam(required=false) String clbumName, @RequestParam(required=false) String realName, @RequestParam(required=false) String userId, @RequestParam(required=false) String fuzzySearch, @RequestParam(required=false) String speName, @RequestParam(required=false, defaultValue="false") Boolean isExport, HttpServletResponse response) {
        Page individuleDetailsBySubject = this.examInfoService.getIndividuleDetailsBySubject(page, examJobId, schoolCode, subjectId, gardName, clbumName, realName, userId, speName, fuzzySearch);
        if (!isExport.booleanValue()) {
            return Result.ok((Object)individuleDetailsBySubject);
        }
        List records = individuleDetailsBySubject.getRecords();
        List<ExamInfoRankBySubjectExport> res = records.stream().map(e -> ExamInfoRankBySubjectExport.of((ExamInfoRankBySubject)e)).toList();
        ExcelUtils.export((HttpServletResponse)response, (String)"\u8003\u8bd5\u6210\u7ee9\u6570\u636e\u67e5\u8be2", res, ExamInfoRankBySubject.class);
        return null;
    }

    @GetMapping(value={"/school/info"})
    @Operation(summary="\u5b66\u6821\u7aef\u8003\u8bd5\u6570\u636e\u67e5\u8be2")
    public Result<Page<ExamInfo>> queryRemoteSchoolExamInfo(Page page, @RequestParam(required=true) String examJobId, @RequestParam(required=true) String schoolCode, @RequestParam(required=true) String specialtyId, @RequestParam(required=false) String examName, @RequestParam(required=false) String realName, @RequestParam(required=false) String studentCode, @RequestParam(required=false) String studyCode, @RequestParam(required=false) String clbumName, @RequestParam(required=false) String specialtyName, @RequestParam(required=false) String gradeName, @RequestParam(required=false) String subjectName, @RequestParam(required=false) String paperName, @RequestParam(required=false) String fuzzySearch) {
        return Result.ok((Object)this.examInfoService.queryRemoteSchoolExamInfo(page, examJobId, schoolCode, specialtyId, examName, realName, studentCode, studyCode, clbumName, specialtyName, gradeName, subjectName, paperName, fuzzySearch));
    }
}

