/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.ExamStudentTeacherMapping;
import com.zsy.exam.service.IExamStudentTeacherMappingService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="exam-student-teacher-mapping", description="")
@RequestMapping(value={"/api/exam-student-teacher-mapping"})
public class ExamStudentTeacherMappingController {
    @Autowired
    private IExamStudentTeacherMappingService examStudentTeacherMappingService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('exam-student-teacher-mapping-selectOne')")
    public Result<ExamStudentTeacherMapping> getExamStudentTeacherMapping(@RequestParam(value="id") Long id) {
        ExamStudentTeacherMapping examStudentTeacherMappingOne = this.examStudentTeacherMappingService.getExamStudentTeacherMapping(id);
        return Result.success((Object)examStudentTeacherMappingOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('exam-student-teacher-mapping-listAll')")
    public Result<Page<ExamStudentTeacherMapping>> getAllExamStudentTeacherMapping(Page page) {
        Page examStudentTeacherMappingList = this.examStudentTeacherMappingService.getAllExamStudentTeacherMapping(page);
        return Result.success((Object)examStudentTeacherMappingList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('exam-student-teacher-mapping-add')")
    public Result add(@Valid @RequestBody ExamStudentTeacherMapping examStudentTeacherMapping) {
        this.examStudentTeacherMappingService.add(examStudentTeacherMapping);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('exam-student-teacher-mapping-update')")
    public Result<Integer> update(@Valid @RequestBody ExamStudentTeacherMapping examStudentTeacherMapping) {
        Integer num = this.examStudentTeacherMappingService.modify(examStudentTeacherMapping);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('exam-student-teacher-mapping-delete')")
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.examStudentTeacherMappingService.remove(ids);
        return Result.success();
    }
}

