/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.ExaminationCatalogueDTO;
import com.zsy.exam.model.vo.ExaminationCatalogueTreeListVO;
import com.zsy.exam.service.IExaminationCatalogueService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="examination-catalogue", description="\u8bd5\u5377\u76ee\u5f55")
@RequestMapping(value={"/examination-catalogue"})
public class ExaminationCatalogueController {
    @Autowired
    private IExaminationCatalogueService examinationCatalogueService;

    @GetMapping(value={"/tree"})
    @Operation(summary="\u8bd5\u5377\u76ee\u5f55\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('examination-catalogue-tree')")
    public Result<List<ExaminationCatalogueTreeListVO>> tree(String examinationName) {
        List examinationCatalogueList = this.examinationCatalogueService.getAllExaminationCatalogue(examinationName);
        return Result.success((Object)examinationCatalogueList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u8bd5\u5377\u76ee\u5f55\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('examination-catalogue-add')")
    @SysLog(title="\u8bd5\u5377\u76ee\u5f55\u65b0\u589e", businessType=BusinessType.INSERT)
    public Result add(@Valid @RequestBody ExaminationCatalogueDTO examinationCatalogue) {
        this.examinationCatalogueService.add(examinationCatalogue);
        return Result.success();
    }

    @PostMapping(value={"/update"})
    @Operation(summary="\u8bd5\u5377\u76ee\u5f55\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('examination-catalogue-update')")
    @SysLog(title="\u8bd5\u5377\u76ee\u5f55\u4fee\u6539", businessType=BusinessType.UPDATE)
    public Result update(@Valid @RequestBody ExaminationCatalogueDTO examinationCatalogue) {
        this.examinationCatalogueService.update(examinationCatalogue);
        return Result.success();
    }

    @GetMapping(value={"/delete"})
    @Operation(summary="\u8bd5\u5377\u76ee\u5f55\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('examination-catalogue-delete')")
    @SysLog(title="\u8bd5\u5377\u76ee\u5f55\u5220\u9664", businessType=BusinessType.DELETE)
    public Result remove(String ids) {
        this.examinationCatalogueService.remove(ids);
        return Result.success();
    }
}

