/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import cn.hutool.core.io.IoUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.ExaminationAutoDTO;
import com.zsy.exam.model.dto.ExaminationDTO;
import com.zsy.exam.model.dto.ExaminationPointDTO;
import com.zsy.exam.model.dto.PaperApproveDto;
import com.zsy.exam.model.dto.PaperExportDto;
import com.zsy.exam.model.form.paper.PaperPageQuery;
import com.zsy.exam.model.vo.ExamAnalysisVO;
import com.zsy.exam.model.vo.ExamSimpleVO;
import com.zsy.exam.model.vo.ExaminationAutoBatchVO;
import com.zsy.exam.model.vo.ExaminationListVO;
import com.zsy.exam.model.vo.QuestionVO;
import com.zsy.exam.service.IExaminationPaperService;
import com.zsy.exam.util.CryptoUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Tag(name="examination", description="\u8bd5\u5377")
@RequestMapping(value={"/examination-paper"})
public class ExaminationPaperController {
    @Autowired
    private IExaminationPaperService examinationService;
    public static String exportSecretKey = "T9FrGWgvjhi/ZY8mS12wBg==";

    @GetMapping(value={"/detail"})
    @Operation(summary="\u8bd5\u5377\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-detail')")
    public Result<ExaminationDTO> detail(@RequestParam(value="id") Long id) {
        ExaminationDTO examinationOne = this.examinationService.getExamination(id);
        return Result.success((Object)examinationOne);
    }

    @GetMapping(value={"/page"})
    @Operation(summary="\u8bd5\u5377\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-page')")
    public Result<Page<ExaminationListVO>> page(Page page, PaperPageQuery query) {
        Page examinationList = this.examinationService.getAllExamination(page, query);
        return Result.success((Object)examinationList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u8bd5\u5377\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-add')")
    @SysLog(title="\u8bd5\u5377\u65b0\u589e", businessType=BusinessType.INSERT)
    public Result add(@Valid @RequestBody ExaminationDTO dto) {
        this.examinationService.add(dto);
        return Result.success();
    }

    @PostMapping(value={"/update"})
    @Operation(summary="\u8bd5\u5377\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-update')")
    @SysLog(title="\u8bd5\u5377\u4fee\u6539", businessType=BusinessType.UPDATE)
    public Result update(@Valid @RequestBody ExaminationDTO dto) {
        this.examinationService.update(dto);
        return Result.success();
    }

    @GetMapping(value={"/submit/{id}"})
    @Operation(summary="\u63d0\u4ea4\u8bd5\u5377")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-submit')")
    public Result submit(@PathVariable(value="id") Long id) {
        this.examinationService.submit(id);
        return Result.ok();
    }

    @GetMapping(value={"/delete"})
    @Operation(summary="\u8bd5\u5377\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @SysLog(title="\u8bd5\u5377\u5220\u9664", businessType=BusinessType.DELETE)
    @PreAuthorize(value="hasAnyAuthority('examination-paper-delete')")
    public Result remove(String ids) {
        this.examinationService.remove(ids);
        return Result.success();
    }

    @PostMapping(value={"/point"})
    @Operation(summary="\u8bd5\u5377\u6253\u5206")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-point')")
    public Result point(@RequestBody List<ExaminationPointDTO> dtos) {
        this.examinationService.point(dtos);
        return Result.success();
    }

    @PostMapping(value={"/auto"})
    @Operation(summary="\u81ea\u52a8\u751f\u6210\u8bd5\u9898")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-auto')")
    public Result<List<QuestionVO>> auto(@RequestBody ExaminationAutoDTO dto) {
        List questionVOS = this.examinationService.generatePaper(dto);
        return Result.success((Object)questionVOS);
    }

    @PostMapping(value={"/batch/auto"})
    @Operation(summary="\u81ea\u52a8\u751f\u6210\u591a\u5957\u8bd5\u9898")
    public Result<List<ExaminationAutoBatchVO>> batchAuto(@RequestBody ExaminationAutoDTO dto) {
        List questionVOS = this.examinationService.generatePaperBatch(dto);
        return Result.success((Object)questionVOS);
    }

    @GetMapping(value={"/exam-info"})
    @Operation(summary="\u8003\u8bd5\u7b80\u5355\u5217\u8868")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-exam-info')")
    public Result<List<ExamSimpleVO>> examInfo(Long id) {
        List questionVOS = this.examinationService.examInfo(id);
        return Result.success((Object)questionVOS);
    }

    @Operation(summary="\u5ba1\u6838\u8bd5\u5377")
    @PutMapping(value={"/approve"})
    @SysLog(title="\u5ba1\u6838\u8bd5\u5377", businessType=BusinessType.UPDATE)
    @PreAuthorize(value="hasAnyAuthority('examination-paper-approve')")
    public Result approve(@RequestBody PaperApproveDto dto) {
        this.examinationService.approve(dto);
        return Result.ok();
    }

    @Operation(summary="\u8bd5\u5377\u5206\u6790")
    @GetMapping(value={"/analysis"})
    @PreAuthorize(value="hasAnyAuthority('examination-paper-analysis')")
    public Result<ExamAnalysisVO> analysis(Long id) {
        ExamAnalysisVO vo = this.examinationService.getAnalysisResult(id);
        return Result.success((Object)vo);
    }

    @GetMapping(value={"/count"})
    @Operation(summary="\u83b7\u53d6\u8bd5\u5377\u6570\u91cf")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-count')")
    public Result<Integer> getCount() {
        Integer examinationCount = this.examinationService.getExaminationCount();
        return Result.success((Object)examinationCount);
    }

    @GetMapping(value={"/export/{id}"})
    @Operation(summary="\u5bfc\u51fa\u8bd5\u5377")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-export')")
    public void export(@PathVariable(value="id") Long id, HttpServletResponse response) {
        PaperExportDto exportDto = this.examinationService.export(id);
        response.setContentType("text/plain;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment; filename=\"\u8bd5\u5377\u5bfc\u51fa.txt\"");
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            String cipherText = CryptoUtils.encryptSymmetrically((String)exportSecretKey, null, (String)JSONUtil.toJsonStr((Object)exportDto), (CryptoUtils.Algorithm)CryptoUtils.Algorithm.Encryption.AES_ECB_PKCS5);
            writer.write(cipherText);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @PostMapping(value={"/import"})
    @Operation(summary="\u5bfc\u5165\u8bd5\u5377")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-import')")
    public Result importPaper(@RequestParam(value="file") MultipartFile file) {
        String originalFilename = file.getOriginalFilename();
        if (!originalFilename.endsWith(".txt")) {
            throw new AppException("\u6587\u4ef6\u540e\u7f00\u4e0d\u6b63\u786e");
        }
        try {
            InputStream inputStream = file.getInputStream();
            String cipherText = IoUtil.read((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            String json = CryptoUtils.decryptSymmetrically((String)exportSecretKey, null, (String)cipherText, (CryptoUtils.Algorithm)CryptoUtils.Algorithm.Encryption.AES_ECB_PKCS5);
            PaperExportDto exportDto = (PaperExportDto)JSONUtil.toBean((String)json, PaperExportDto.class);
            this.examinationService.importPaper(exportDto, Integer.valueOf(2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return Result.success();
    }

    @GetMapping(value={"/exportOnLine/{id}"})
    @Operation(summary="\u5728\u7ebf\u5206\u53d1\u8bd5\u5377")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-exportOnLine')")
    public void exportOnLine(@PathVariable(value="id") Long id, HttpServletResponse response) {
        PaperExportDto exportDto = this.examinationService.export(id);
        String jsonStr = JSONUtil.toJsonStr((Object)exportDto);
        String result = HttpUtil.post((String)"url", (String)jsonStr);
    }
}

