/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.ExaminationPaperHtml;
import com.zsy.exam.service.IExaminationPaperHtmlService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="examination-paper-html", description="\u8bd5\u5377-\u8003\u8bd5\u6253\u5370\u7684html")
@RequestMapping(value={"/api/examination-paper-html"})
public class ExaminationPaperHtmlController {
    @Autowired
    private IExaminationPaperHtmlService examinationPaperHtmlService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u8bd5\u5377-\u8003\u8bd5\u6253\u5370\u7684html\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-html-selectOne')")
    public Result<ExaminationPaperHtml> getExaminationPaperHtml(@RequestParam(value="id") Long id) {
        ExaminationPaperHtml examinationPaperHtmlOne = this.examinationPaperHtmlService.getExaminationPaperHtml(id);
        return Result.success((Object)examinationPaperHtmlOne);
    }

    @GetMapping(value={"/getByExamId/{examId}"})
    @Operation(summary="\u8bd5\u5377-\u8003\u8bd5\u6253\u5370\u7684html\u6839\u636e\u8003\u8bd5id\u67e5\u8be2")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-html-getByExamId')")
    public Result<ExaminationPaperHtml> getByExamId(@PathVariable(value="examId") Long examId) {
        ExaminationPaperHtml db = this.examinationPaperHtmlService.getByExamId(examId);
        return Result.success((Object)db);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u8bd5\u5377-\u8003\u8bd5\u6253\u5370\u7684html\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-html-add')")
    public Result add(@Valid @RequestBody ExaminationPaperHtml examinationPaperHtml) {
        this.examinationPaperHtmlService.add(examinationPaperHtml);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u8bd5\u5377-\u8003\u8bd5\u6253\u5370\u7684html\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-html-update')")
    public Result<Integer> update(@Valid @RequestBody ExaminationPaperHtml examinationPaperHtml) {
        Integer num = this.examinationPaperHtmlService.modify(examinationPaperHtml);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u8bd5\u5377-\u8003\u8bd5\u6253\u5370\u7684html\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('examination-paper-html-delete')")
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.examinationPaperHtmlService.remove(ids);
        return Result.success();
    }
}

