/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.vo.exercise.ExerciseCatalogueDTO;
import com.zsy.exam.model.vo.exercise.ExerciseCatalogueTreeListVO;
import com.zsy.exam.service.IExerciseCatalogueService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="exercise-catalogue", description="\u7ec3\u4e60\u76ee\u5f55")
@RequestMapping(value={"/api/exerciseCatalogue"})
public class ExerciseCatalogueController {
    @Autowired
    private IExerciseCatalogueService examinationCatalogueService;

    @GetMapping(value={"/tree"})
    @Operation(summary="\u7ec3\u4e60\u76ee\u5f55\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('exerciseCatalogue-tree')")
    public Result<List<ExerciseCatalogueTreeListVO>> tree() {
        List examinationCatalogueList = this.examinationCatalogueService.getAllExerciseCatalogue();
        return Result.success((Object)examinationCatalogueList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u7ec3\u4e60\u76ee\u5f55\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('exerciseCatalogue-add')")
    @SysLog(title="\u7ec3\u4e60\u76ee\u5f55\u65b0\u589e", businessType=BusinessType.INSERT)
    public Result add(@Valid @RequestBody ExerciseCatalogueDTO examinationCatalogue) {
        this.examinationCatalogueService.add(examinationCatalogue);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u7ec3\u4e60\u76ee\u5f55\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('exerciseCatalogue-update')")
    @SysLog(title="\u7ec3\u4e60\u76ee\u5f55\u4fee\u6539", businessType=BusinessType.UPDATE)
    public Result update(@Valid @RequestBody ExerciseCatalogueDTO examinationCatalogue) {
        this.examinationCatalogueService.update(examinationCatalogue);
        return Result.success();
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u7ec3\u4e60\u76ee\u5f55\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('exerciseCatalogue-delete')")
    @SysLog(title="\u7ec3\u4e60\u76ee\u5f55\u5220\u9664", businessType=BusinessType.DELETE)
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.examinationCatalogueService.remove(ids);
        return Result.success();
    }
}

