/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.exercise.ExerciseDTO;
import com.zsy.exam.model.entity.ExerciseRecord;
import com.zsy.exam.model.form.exercise.ExerciseForm;
import com.zsy.exam.model.vo.exercise.ExerciseByStudentPageVO;
import com.zsy.exam.model.vo.exercise.ExerciseRecordStudentPageVO;
import com.zsy.exam.model.vo.exercise.ExerciseVO;
import com.zsy.exam.service.IExerciseRecordService;
import com.zsy.exam.service.IExerciseService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="exercise-teacher", description="\u7ec3\u4e60\u6559\u5e08\u7ba1\u7406\u7aef")
@RequestMapping(value={"/api/exercise/teacher"})
public class ExerciseController {
    @Autowired
    private IExerciseService exerciseService;
    @Autowired
    private IExerciseRecordService recordService;

    @GetMapping(value={"/detail/{id}"})
    @Operation(summary="\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('exercise-teacher-detail')")
    public Result<ExerciseVO> detail(@PathVariable(value="id") Long id) {
        ExerciseVO exerciseOne = this.exerciseService.detail(id);
        return Result.success((Object)exerciseOne);
    }

    @GetMapping(value={"/page"})
    @Operation(summary="\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('exercise-teacher-page')")
    public Result<Page<ExerciseVO>> getAllExercise(Page page, ExerciseForm query) {
        Page exerciseList = this.exerciseService.getPage(page, query);
        return Result.success((Object)exerciseList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('exercise-teacher-add')")
    @SysLog(title="\u7ec3\u4e60\u65b0\u589e", businessType=BusinessType.INSERT)
    public Result add(@Valid @RequestBody ExerciseDTO dto) {
        this.exerciseService.add(dto);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('exercise-teacher-update')")
    @SysLog(title="\u7ec3\u4e60\u4fee\u6539", businessType=BusinessType.UPDATE)
    public Result<Integer> update(@Valid @RequestBody ExerciseDTO exercise) {
        Integer num = this.exerciseService.modify(exercise);
        return Result.success((Object)num);
    }

    @GetMapping(value={"/maxExerciseNumber/{subjectCode}"})
    @Operation(summary="\u7ec3\u4e60\u6700\u5927\u7684\u9898\u6570")
    @PreAuthorize(value="hasAnyAuthority('exercise-teacher-maxExerciseNumber')")
    public Result<Integer> maxExerciseNumber(@PathVariable(value="subjectCode") String subjectCode) {
        Integer number = this.exerciseService.maxExerciseNumber(subjectCode);
        return Result.success((Object)number);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('exercise-teacher-delete')")
    @SysLog(title="\u7ec3\u4e60\u5220\u9664", businessType=BusinessType.DELETE)
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.exerciseService.remove(ids);
        return Result.success();
    }

    @GetMapping(value={"/getExerciseByStudent/{userId}"})
    @Operation(summary="\u901a\u8fc7\u5b66\u751fid\u67e5\u8be2\u7ec3\u4e60\u5206\u9875")
    @PreAuthorize(value="hasAnyAuthority( 'exercise-teacher-getExerciseByStudent')")
    @SysLog(title="\u7ec3\u4e60\u5220\u9664", businessType=BusinessType.DELETE)
    Result<Page<ExerciseByStudentPageVO>> getExerciseByStudent(Page page, String key, @PathVariable(value="userId") Long userId, String subjectCode) {
        return Result.success((Object)this.exerciseService.getExerciseByStudent(page, key, userId, subjectCode));
    }

    @GetMapping(value={"/studentRecords/{exerciseId}/{studentUserId}"})
    @Operation(summary="\u901a\u8fc7\u5b66\u751fid\u67e5\u8be2\u7ec3\u4e60\u8be6\u60c5")
    @PreAuthorize(value="hasAnyAuthority( 'exercise-teacher-studentRecords')")
    public Result<ExerciseRecord> studentRecords(@PathVariable(value="exerciseId") Long exerciseId, @PathVariable(value="studentUserId") Long studentUserId) {
        return Result.success((Object)this.recordService.detail(studentUserId, exerciseId));
    }

    @GetMapping(value={"/records/detail/{id}"})
    @Operation(summary="\u83b7\u53d6\u5355\u6b21\u7ec3\u4e60\u5b66\u751f\u8bb0\u5f55\u60c5\u51b5")
    @PreAuthorize(value="hasAnyAuthority('exercise-teacher-records-detail')")
    public Result<Page<ExerciseRecordStudentPageVO>> getExerciseRecordStudentPage(Page page, @PathVariable(value="id") Long id, String key) {
        return Result.success((Object)this.recordService.getExerciseRecordStudentPage(page, id, key));
    }

    @GetMapping(value={"/records/allGroupByStudent"})
    @Operation(summary="\u67e5\u8be2\u6240\u6709\u5b66\u751f\u7684\u7ec3\u4e60\u603b\u89c8")
    @PreAuthorize(value="hasAnyAuthority( 'exercise-teacher-records-allGroupByStudent')")
    public Result<Page<ExerciseRecordStudentPageVO>> getAllRecordGroupByStudent(Page page, String key, Long clbumId, String subjectCode) {
        return Result.success((Object)this.recordService.getAllRecordGroupByStudent(page, key, clbumId, subjectCode));
    }

    @GetMapping(value={"/records/getTotalCount"})
    @Operation(summary="\u5237\u9898\u603b\u6570")
    @PreAuthorize(value="hasAnyAuthority('exercise-teacher-records-getTotalCount')")
    public Result<Long> getRecordsTotalCount() {
        return Result.success((Object)this.recordService.getTotalCount());
    }

    @GetMapping(value={"/weekOnWeek"})
    @Operation(summary="\u7ec3\u4e60\u603b\u6570\uff0c\u5468\u73af\u6bd4")
    @PreAuthorize(value="hasAnyAuthority('exercise-teacher-weekOnWeek')")
    public Result<HashMap<String, Object>> weekOnWeek() {
        return Result.ok((Object)this.exerciseService.weekOnWeek());
    }

    @GetMapping(value={"/records/weekOnWeek"})
    @Operation(summary="\u7ec3\u4e60\u5468\u4eba\u6b21\u6570\uff0c\u5468\u73af\u6bd4")
    @PreAuthorize(value="hasAnyAuthority('exercise-teacher-records-weekOnWeek')")
    public Result<HashMap<String, Object>> recordWeekOnWeek(String subjectCode) {
        return Result.ok((Object)this.recordService.WeekOnWeek(subjectCode));
    }

    @GetMapping(value={"/records/today"})
    @Operation(summary="\u7edf\u8ba1\u6240\u6709\u5b66\u751f\u7684\u4eca\u65e5\u5237\u9898\u91cf")
    @PreAuthorize(value="hasAnyAuthority('exercise-teacher-records-today')")
    public Result<Long> todayRecords() {
        return Result.ok((Object)this.recordService.todayRecords());
    }
}

