/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.exercise.ExerciseRecordDto;
import com.zsy.exam.model.entity.ExerciseRecord;
import com.zsy.exam.model.form.exercise.ExerciseForm;
import com.zsy.exam.model.vo.QuestionVO;
import com.zsy.exam.model.vo.exercise.ExerciseForStudentVO;
import com.zsy.exam.service.IExerciseRecordService;
import com.zsy.exam.service.IExerciseService;
import com.zsy.exam.service.IQuestionService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Tag(name="exercise-student", description="\u7ec3\u4e60\u5b66\u751f\u7aef")
@RequestMapping(value={"/api/exercise/student"})
public class ExerciseStudentController {
    @Autowired
    private IExerciseService exerciseService;
    @Autowired
    private IExerciseRecordService recordService;
    @Autowired
    private IQuestionService questionService;

    @GetMapping(value={"/page"})
    @Operation(summary="\u67e5\u8be2\u5168\u90e8\u7ec3\u4e60")
    @PreAuthorize(value="hasAnyAuthority('exercise-student-page')")
    public Result<Page<ExerciseForStudentVO>> getAllExercise(Page page, ExerciseForm query) {
        Page exerciseList = this.exerciseService.getPage4Student(page, query);
        return Result.success((Object)exerciseList);
    }

    @GetMapping(value={"/detail/{id}"})
    @Operation(summary="\u7ec3\u4e60\u8be6\u60c5")
    @PreAuthorize(value="hasAnyAuthority('exercise-student-detail')")
    public Result<ExerciseForStudentVO> getAllExercise(@PathVariable(value="id") Long id) {
        ExerciseForStudentVO vo = this.exerciseService.getDetail4Student(id);
        return Result.success((Object)vo);
    }

    @RequestMapping(value={"/uploadImageForUE"})
    @PreAuthorize(value="hasAnyAuthority('exercise-student-uploadImageForUE')")
    public Object uploadImageForUE(@RequestParam(value="action") String action, MultipartFile file) {
        return this.questionService.uploadImageForUE(action, file, Integer.valueOf(3));
    }

    @GetMapping(value={"/getQuestion/{exerciseId}/{quId}"})
    @Operation(summary="\u6839\u636e\u7ec3\u4e60\u67e5\u8be2\u8bd5\u9898")
    @PreAuthorize(value="hasAnyAuthority('exercise-student-getQuestion')")
    public Result<QuestionVO> getAllExercise(@PathVariable(value="exerciseId") Long exerciseId, @PathVariable(value="quId") Long quId) {
        this.exerciseService.checkQuestionExist(exerciseId, quId);
        QuestionVO questionVO = this.questionService.selectDetailWithOutAnswer(quId);
        return Result.success((Object)questionVO);
    }

    @PostMapping(value={"/addRecord"})
    @Operation(summary="\u7ec3\u4e60\u7b54\u9898")
    @PreAuthorize(value="hasAnyAuthority('exercise-student-addRecord')")
    public Result<ExerciseRecord> addRecord(@RequestBody ExerciseRecordDto dto) {
        return Result.success((Object)this.recordService.addRecord(dto));
    }

    @PostMapping(value={"/repeatExercise"})
    @Operation(summary="\u56de\u987e\u7b54\u9898")
    @PreAuthorize(value="hasAnyAuthority('exercise-student-repeatExercise')")
    public Result repeatExercise(@RequestBody List<ExerciseRecordDto> dtos) {
        this.recordService.repeatExercise(dtos);
        return Result.success();
    }

    @PostMapping(value={"/repeatExerciseCache/{exerciseId}"})
    @Operation(summary="\u56de\u987e\u7b54\u9898\u7f13\u5b58")
    @PreAuthorize(value="hasAnyAuthority('exercise-student-repeatExerciseCache')")
    public Result repeatExerciseCache(@PathVariable Long exerciseId, @RequestBody HashMap<String, String> answerProcess) {
        return Result.success((String)this.recordService.repeatExerciseCache(exerciseId, answerProcess));
    }

    @GetMapping(value={"/recordDetail/{id}"})
    @Operation(summary="\u7ec3\u4e60\u7b54\u9898\u8be6\u60c5")
    @PreAuthorize(value="hasAnyAuthority('exercise-student-recordDetail')")
    public Result<ExerciseRecord> recordDetail(@PathVariable(value="id") Long id) {
        return Result.success((Object)this.recordService.detail(id));
    }

    @GetMapping(value={"/getAnswer/{exerciseId}/{quId}"})
    @Operation(summary="\u67e5\u8be2\u7ec3\u4e60\u9898\u7b54\u6848")
    @PreAuthorize(value="hasAnyAuthority('exercise-student-getAnswer')")
    public Result<QuestionVO> getAnswer(@PathVariable(value="exerciseId") Long exerciseId, @PathVariable(value="quId") Long quId) {
        this.exerciseService.checkQuestionExist(exerciseId, quId);
        QuestionVO questionVO = this.questionService.getAnswer(quId);
        return Result.success((Object)questionVO);
    }

    @GetMapping(value={"/recordCount"})
    @Operation(summary="\u7ec3\u4e60\u6b21\u6570")
    @PreAuthorize(value="hasAnyAuthority('exercise-student-recordCount')")
    public Result<Long> recordCount() {
        return Result.success((Object)this.recordService.studentRecordCount());
    }
}

