/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.Grade;
import com.zsy.exam.service.IGradeService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Tag(name="grade", description="\u5e74\u7ea7")
@RequestMapping(value={"/grade"})
public class GradeController {
    @Autowired
    private IGradeService gradeService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u5e74\u7ea7\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('grade-selectOne')")
    public Result<Grade> getGrade(@RequestParam(value="id") Long id) {
        Grade gradeOne = this.gradeService.getGrade(id);
        return Result.success((Object)gradeOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u5e74\u7ea7\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('grade-listAll')")
    public Result<Page<List<Grade>>> getAllGrade(Page page, @RequestParam(value="name", required=false) String name, @RequestParam(value="code", required=false) String code, @RequestParam(value="enable", required=false) Boolean enable) {
        Page gradeList = this.gradeService.getAllGrade(page, name, code);
        return Result.success((Object)gradeList);
    }

    @GetMapping(value={"/listGradeFromExam"})
    @Operation(summary="\u67e5\u8be2\u8003\u8bd5\u6240\u5305\u542b\u7684\u5e74\u7ea7")
    @PreAuthorize(value="hasAnyAuthority('grade-selectOne')")
    public Result<Set<String>> listGradeFromExam(Long examId) {
        Set examGradeList = this.gradeService.listGradeFromExam(examId);
        return Result.success((Object)examGradeList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u5e74\u7ea7\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('grade-add')")
    @SysLog(title="\u5e74\u7ea7\u65b0\u589e", businessType=BusinessType.INSERT)
    public Result add(@Valid @RequestBody Grade grade) {
        this.gradeService.add(grade);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u5e74\u7ea7\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('grade-update')")
    @SysLog(title="\u5e74\u7ea7\u4fee\u6539", businessType=BusinessType.UPDATE)
    public Result<Integer> update(@Valid @RequestBody Grade grade) {
        Integer num = this.gradeService.modify(grade);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u5e74\u7ea7\u5220\u9664(\u5355\u4e2a\u6761\u76ee)")
    @PreAuthorize(value="hasAnyAuthority('grade-delete')")
    @SysLog(title="\u5e74\u7ea7\u5220\u9664", businessType=BusinessType.DELETE)
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.gradeService.remove(ids);
        return Result.success();
    }

    @PostMapping(value={"importGrade"})
    @PreAuthorize(value="hasAnyAuthority('grade-importGrade')")
    @SysLog(title="\u5bfc\u5165\u5e74\u7ea7", businessType=BusinessType.IMPORT)
    public Result importGrade(@RequestParam(value="file") MultipartFile file) throws Exception {
        this.gradeService.importGrade(file);
        return Result.success();
    }

    @GetMapping(value={"exportGrade"})
    @PreAuthorize(value="hasAnyAuthority('grade-exportGrade')")
    public Result exportGrade(HttpServletResponse response, String name, String code) {
        this.gradeService.exportGrade(response, name, code);
        return Result.success();
    }
}

