/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.KnowledgePoints;
import com.zsy.exam.model.entity.twoway.TwowayDetailTable;
import com.zsy.exam.model.vo.kp.KnowledgePointsVO;
import com.zsy.exam.service.ICatalogueService;
import com.zsy.exam.service.IKnowledgePointsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/knowledge-points"})
@Tag(name="knowledge-points", description="\u77e5\u8bc6\u70b9\u7ba1\u7406")
public class KnowledgePointsController {
    @Autowired
    private IKnowledgePointsService knowledgePointsService;
    @Autowired
    private ICatalogueService catalogueService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u77e5\u8bc6\u70b9\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('knowledge-points-selectOne')")
    public Result<KnowledgePoints> getKnowledgePoints(@RequestParam(value="id") Long id) {
        KnowledgePoints knowledgePointsOne = this.knowledgePointsService.getKnowledgePoints(id);
        return Result.success((Object)knowledgePointsOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u77e5\u8bc6\u70b9\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('knowledge-points-listAll')")
    public Result<Page<KnowledgePointsVO>> getAllKnowledgePoints(Page page) {
        Page knowledgePointsList = this.knowledgePointsService.getAllKnowledgePoints(page);
        return Result.success((Object)knowledgePointsList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u77e5\u8bc6\u70b9\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('knowledge-points-add')")
    public Result add(@Valid @RequestBody KnowledgePoints knowledgePoints) {
        this.knowledgePointsService.add(knowledgePoints);
        return Result.success();
    }

    @PostMapping(value={"/transform"})
    @Operation(summary="\u53cc\u5411\u7ec6\u76ee\u8868\u8f6c\u5316\u4e3a\u77e5\u8bc6\u70b9")
    @PreAuthorize(value="hasAnyAuthority('knowledge-points-transform')")
    public Result add(@Valid @RequestBody TwowayDetailTable twowayDetailTable) {
        KnowledgePoints knowledgePoints = KnowledgePoints.of((TwowayDetailTable)twowayDetailTable);
        this.knowledgePointsService.add(knowledgePoints);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u77e5\u8bc6\u70b9\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('knowledge-points-update')")
    public Result<Integer> update(@Valid @RequestBody KnowledgePoints knowledgePoints) {
        Integer num = this.knowledgePointsService.modify(knowledgePoints);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u77e5\u8bc6\u70b9\u5220\u9664(\u5355\u4e2a\u6761\u76ee)")
    @PreAuthorize(value="hasAnyAuthority('knowledge-points-delete')")
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.knowledgePointsService.remove(ids);
        return Result.success();
    }

    @GetMapping(value={"/tree/{type}"})
    @Operation(summary="\u76ee\u5f55\u6811")
    @PreAuthorize(value="hasAnyAuthority('knowledge-points-tree')")
    public Result getDataTreePage(@PathVariable String type, String pathCode) {
        return Result.success((Object)this.catalogueService.getTree(type, pathCode, null));
    }

    @GetMapping(value={"/tree/detail"})
    @Operation(summary="\u83b7\u53d6\u77e5\u8bc6\u70b9\u6811\u4e0a\u7684\u9898\u578b\u7edf\u8ba1\u8be6\u7ec6")
    @PreAuthorize(value="hasAnyAuthority('knowledge-points-tree-detail')")
    public Result getDataTreePageDetail(Page page, @RequestParam Long id, @RequestParam String subjectCode, @RequestParam(required=false) String name) {
        return Result.success((Object)this.catalogueService.getTreeKpDetails(page, id, subjectCode, name));
    }

    @GetMapping(value={"/tree/qutype/detail"})
    @Operation(summary="\u901a\u8fc7\u77e5\u8bc6\u70b9\u6811\u8bd5\u9898\u7c7b\u578b\u53cd\u67e5\u77e5\u8bc6\u70b9\u8be6\u7ec6")
    @PreAuthorize(value="hasAnyAuthority('knowledge-points-tree-qutype-detail')")
    public Result getDataTreePageByQuType(Page page, @RequestParam Long id, @RequestParam String kpCode, @RequestParam String type) {
        return Result.success((Object)this.catalogueService.getDataTreePageByQuType(page, id, kpCode, type));
    }
}

