/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.LoginPageListDTO;
import com.zsy.exam.model.dto.PdfLogAddDTO;
import com.zsy.exam.model.entity.LoginLog;
import com.zsy.exam.model.entity.OptLog;
import com.zsy.exam.service.ILoginLogService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="login-log", description="\u65e5\u5fd7\u4fe1\u606f")
@RequestMapping(value={"/login-log"})
public class LoginLogController {
    @Autowired
    private ILoginLogService loginLogService;

    @GetMapping(value={"/opt-page"})
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u7cfb\u7edf\u65e5\u5fd7\u8868")
    @PreAuthorize(value="hasAnyAuthority('login-log-opt-page')")
    public Result<IPage<OptLog>> getPage(Page page, LoginPageListDTO dto) {
        Page optLogPage = this.loginLogService.getPage(page, dto);
        return Result.success((Object)optLogPage);
    }

    @GetMapping(value={"/login-page"})
    @Operation(summary="\u5206\u9875\u67e5\u8be2\u767b\u5f55\u65e5\u5fd7")
    @PreAuthorize(value="hasAnyAuthority('login-log-login-page')")
    public Result<IPage<LoginLog>> getLoginPage(Page page, LoginPageListDTO dto) {
        Page logPage = this.loginLogService.getLoginLogPage(page, dto);
        return Result.success((Object)logPage);
    }

    @PostMapping(value={"/addPdfLog"})
    @Operation(summary="PDF\u4e0b\u8f7d\u65e5\u5fd7")
    @PreAuthorize(value="hasAnyAuthority('login-log-addPdfLog')")
    public Result addPdfLog(@RequestBody PdfLogAddDTO dto, HttpServletRequest request) {
        this.loginLogService.addPdfLog(request, dto);
        return Result.success();
    }

    @GetMapping(value={"/exportOptLog"})
    @Operation(summary="\u7cfb\u7edf\u65e5\u5fd7\u5bfc\u51fa")
    @PreAuthorize(value="hasAnyAuthority('login-log-exportOptLog')")
    public Result exportOptLog(HttpServletResponse response, LoginPageListDTO dto) {
        this.loginLogService.exportOptLog(response, dto);
        return Result.success();
    }

    @GetMapping(value={"/exportLoginLog"})
    @PreAuthorize(value="hasAnyAuthority('login-log-exportLoginLog')")
    @Operation(summary="\u767b\u5f55\u65e5\u5fd7\u5bfc\u51fa")
    public Result exportLoginLog(HttpServletResponse response, LoginPageListDTO dto) {
        this.loginLogService.exportLoginLog(response, dto);
        return Result.success();
    }
}

