/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.MenuDTO;
import com.zsy.exam.model.vo.MenuTreeListVO;
import com.zsy.exam.service.IMenuService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="menu", description="\u83dc\u5355")
@RequestMapping(value={"/menu"})
public class MenuController {
    @Autowired
    private IMenuService menuService;

    @GetMapping(value={"/detail"})
    @Operation(summary="\u8be6\u60c5")
    @PreAuthorize(value="hasAnyAuthority('menu-detail')")
    public Result<MenuDTO> getMenu(@RequestParam(value="id") Long id) {
        MenuDTO menuOne = this.menuService.getMenu(id);
        return Result.success((Object)menuOne);
    }

    @GetMapping(value={"/tree"})
    @Operation(summary="\u83dc\u5355\u5217\u8868\u6811")
    @PreAuthorize(value="hasAnyAuthority('menu-tree')")
    public Result<List<MenuTreeListVO>> getAllMenu() {
        List allMenu = this.menuService.getTree();
        return Result.success((Object)allMenu);
    }

    @GetMapping(value={"/page"})
    @Operation(summary="\u83dc\u5355\u5206\u9875")
    @PreAuthorize(value="hasAnyAuthority('menu-page')")
    public Result<Page<MenuTreeListVO>> page(Page page, String name) {
        Page allMenu = this.menuService.page(page, name);
        return Result.success((Object)allMenu);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u83dc\u5355\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('menu-add')")
    public Result add(@Valid @RequestBody MenuDTO dto) {
        this.menuService.add(dto);
        return Result.success();
    }

    @PostMapping(value={"/update"})
    @Operation(summary="\u83dc\u5355\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('menu-update')")
    public Result update(@Valid @RequestBody MenuDTO menu) {
        this.menuService.modify(menu);
        return Result.success();
    }

    @GetMapping(value={"/delete"})
    @Operation(summary="\u83dc\u5355\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('menu-delete')")
    public Result remove(@NotBlank(message="{required}") @NotBlank(message="{required}") String ids) {
        this.menuService.remove(ids);
        return Result.success();
    }
}

