/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.MessageConfig;
import com.zsy.exam.model.vo.MessageConfigVO;
import com.zsy.exam.service.IMessageConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="message-config", description="\u6d88\u606f\u914d\u7f6e\u8868")
@RequestMapping(value={"/api/message-config"})
public class MessageConfigController {
    @Autowired
    private IMessageConfigService messageConfigService;

    @GetMapping(value={"/list"})
    @Operation(summary="\u6d88\u606f\u914d\u7f6e\u8868\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('message-config-list')")
    public Result<List<MessageConfig>> getAllMessageConfig() {
        List messageConfigList = this.messageConfigService.listAll();
        return Result.success((Object)messageConfigList);
    }

    @PostMapping(value={"/addOrUpdate"})
    @Operation(summary="\u6d88\u606f\u914d\u7f6e\u8868\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('message-config-addOrUpdate')")
    public Result addOrUpdate(@Valid @RequestBody MessageConfigVO vo) {
        this.messageConfigService.addOrUpdate(vo);
        return Result.success();
    }
}

