/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.NoticeClick;
import com.zsy.exam.model.form.NoticeForm;
import com.zsy.exam.model.vo.NoticeVO;
import com.zsy.exam.service.INoticeService;
import jakarta.annotation.Resource;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/notices"})
public class NoticeController {
    @Resource
    private INoticeService noticeService;

    @PostMapping(value={"add"})
    @PreAuthorize(value="hasAnyAuthority('notices-add')")
    public Result<String> addNotice(@Validated @RequestBody NoticeForm noticeForm) {
        this.noticeService.addNotice(noticeForm);
        return Result.success();
    }

    @PostMapping(value={"delete"})
    @PreAuthorize(value="hasAnyAuthority('notices-delete')")
    public Result<String> deleteNotice(String ids) {
        this.noticeService.deleteNotice(ids);
        return Result.success();
    }

    @PostMapping(value={"update"})
    @PreAuthorize(value="hasAnyAuthority('notices-update')")
    public Result<String> updateNotice(@RequestBody NoticeForm noticeForm) {
        this.noticeService.updateNotice(noticeForm);
        return Result.success();
    }

    @GetMapping(value={"/page"})
    @PreAuthorize(value="hasAnyAuthority('notices-page')")
    public Result<IPage<NoticeVO>> getNotice(Page page, @RequestParam(value="title", required=false) String title, @RequestParam(value="isCollect", required=false) Integer isCollect) {
        IPage notice = this.noticeService.getNotice(page, title, isCollect);
        return Result.success((Object)notice);
    }

    @PostMapping(value={"/click"})
    @PreAuthorize(value="hasAnyAuthority('notices-click')")
    public Result click(@RequestBody NoticeClick click) {
        this.noticeService.click(click);
        return Result.success();
    }

    @GetMapping(value={"/collect"})
    @PreAuthorize(value="hasAnyAuthority('notices-collect')")
    public Result collect(Long noticeId) {
        this.noticeService.collect(noticeId);
        return Result.success();
    }
}

