/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.Post;
import com.zsy.exam.service.IPostService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="post", description="")
@RequestMapping(value={"/post"})
public class PostController {
    @Autowired
    private IPostService postService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('post-selectOne')")
    public Result<Post> getPost(@RequestParam(value="id") Long id) {
        Post postOne = this.postService.getPost(id);
        return Result.success((Object)postOne);
    }

    @GetMapping(value={"/page"})
    @Operation(summary="\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('post-page')")
    public Result<Page<List<Post>>> getAllPost(Page page) {
        Page postList = this.postService.getAllPost(page);
        return Result.success((Object)postList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('post-add')")
    public Result add(@Valid @RequestBody Post post) {
        this.postService.add(post);
        return Result.success();
    }

    @PostMapping(value={"/update"})
    @Operation(summary="\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('post-update')")
    public Result<Integer> update(@Valid @RequestBody Post post) {
        Integer num = this.postService.modify(post);
        return Result.success((Object)num);
    }

    @GetMapping(value={"/delete"})
    @Operation(summary="\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('post-delete')")
    public Result remove(@NotBlank(message="{required}") @NotBlank(message="{required}") String ids) {
        this.postService.remove(ids);
        return Result.success();
    }
}

