/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.group.QuestionGroup;
import com.zsy.exam.common.result.Key2Value;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.QuestionApproveDto;
import com.zsy.exam.model.dto.ExaminationAutoTypeDTO;
import com.zsy.exam.model.form.question.QuestionExportFrom;
import com.zsy.exam.model.form.question.QuestionFrom;
import com.zsy.exam.model.form.question.QuestionImportResult;
import com.zsy.exam.model.form.question.QuestionOnlyContentFrom;
import com.zsy.exam.model.form.question.QuestionPageQuery;
import com.zsy.exam.model.vo.QuestionVO;
import com.zsy.exam.service.IQuestionService;
import com.zsy.exam.service.ISubjectService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/questions"})
public class QuestionController {
    @Resource
    private IQuestionService questionService;
    @Resource
    @Lazy
    private ISubjectService subjectService;

    @PostMapping(value={"/add"})
    @PreAuthorize(value="hasAnyAuthority('questions-add','question-person-add')")
    @SysLog(title="\u9898\u76ee\u6dfb\u52a0", businessType=BusinessType.INSERT)
    public Result<List<Long>> addSingleQuestion(@Validated(value={QuestionGroup.QuestionAddGroup.class}) @RequestBody List<QuestionFrom> questionFrom, Integer belong) {
        List ids = this.questionService.addQuestion(questionFrom, belong);
        return Result.ok((Object)ids);
    }

    @DeleteMapping(value={"/batch/{ids}"})
    @PreAuthorize(value="hasAnyAuthority('questions-batch-delete','question-person-batch-delete')")
    @SysLog(title="\u9898\u76ee\u6279\u91cf\u5220\u9664", businessType=BusinessType.DELETE)
    public Result<String> deleteBatchQuestion(@PathVariable(value="ids") String ids) {
        List<Long> list = Arrays.stream(ids.split(",")).map(Long::parseLong).toList();
        return this.questionService.deleteBatchByIds(list);
    }

    @GetMapping(value={"/paging"})
    @PreAuthorize(value="hasAnyAuthority('questions-paging')")
    public Result<IPage<QuestionVO>> pagingQuestion(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, QuestionPageQuery query) {
        return Result.ok((Object)this.questionService.pagingQuestion(pageNum, pageSize, query));
    }

    @GetMapping(value={"/demoPaging"})
    @PreAuthorize(value="hasAnyAuthority('questions-demoPaging')")
    public Result<IPage<QuestionVO>> demoPaging(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, QuestionPageQuery query) {
        return Result.ok((Object)this.questionService.demoPreviewModePagingQuestion(pageNum, pageSize, query));
    }

    @GetMapping(value={"/getNumByCatalogue"})
    @PreAuthorize(value="hasAnyAuthority('questions-getNumByCatalogue')")
    public Result<List<Key2Value>> getNumByCatalogue(QuestionPageQuery query) {
        return Result.ok((Object)this.questionService.getNumByCatalogue(query));
    }

    @GetMapping(value={"/detail/{id}"})
    @PreAuthorize(value="hasAnyAuthority('questions-detail','questions-person-detail','questions-approve-detail')")
    public Result<QuestionVO> detail(@PathVariable(value="id") Long id) {
        return Result.ok((Object)this.questionService.detail(id));
    }

    @GetMapping(value={"/personalBelongShare2School/{id}"})
    @PreAuthorize(value="hasAnyAuthority('questions-personalBelongShare2School')")
    @Operation(summary="\u5c06\u4e2a\u4eba\u5e93\u8bd5\u9898\u5171\u4eab\u5230\u5b66\u6821\u5e93")
    public Result personalBelongShare2School(@PathVariable(value="id") Long id) {
        this.questionService.personalBelongShare2School(id);
        return Result.ok();
    }

    @GetMapping(value={"/batch-detail"})
    @PreAuthorize(value="hasAnyAuthority('questions-batch-detail')")
    public Result<List<QuestionVO>> detail(String ids) {
        return Result.ok((Object)this.questionService.batchDetail(ids));
    }

    @PutMapping(value={"/{id}"})
    @PreAuthorize(value="hasAnyAuthority('questions-update','questions-approve-update','questions-feedback-update')")
    @SysLog(title="\u4fee\u6539\u8bd5\u9898", businessType=BusinessType.UPDATE)
    public Result<String> updateQuestion(@PathVariable(value="id") Long id, @RequestBody QuestionFrom questionFrom) {
        questionFrom.setId(id);
        return this.questionService.updateQuestion(questionFrom);
    }

    @PutMapping(value={"/person/{id}"})
    @PreAuthorize(value="hasAnyAuthority('questions-person-update')")
    @SysLog(title="\u4fee\u6539\u8bd5\u9898", businessType=BusinessType.UPDATE)
    public Result<String> updatePersonQuestion(@PathVariable(value="id") Long id, @RequestBody QuestionFrom questionFrom) {
        questionFrom.setId(id);
        return this.questionService.updateQuestion(questionFrom);
    }

    @PutMapping(value={"/updateOnlyContent/{id}"})
    @PreAuthorize(value="hasAnyAuthority('questions-updateOnlyContent')")
    @SysLog(title="\u4fee\u6539\u8bd5\u9898 \u4ec5\u4ec5\u4fee\u6539\u6587\u5b57\u5185\u5bb9", businessType=BusinessType.UPDATE)
    public Result<String> updateQuestion(@PathVariable(value="id") Long id, @RequestBody QuestionOnlyContentFrom questionFrom) {
        questionFrom.setId(id);
        return this.questionService.updateQuestionOnlyContent(questionFrom);
    }

    @PostMapping(value={"/import"})
    @PreAuthorize(value="hasAnyAuthority('questions-import','questions-person-import')")
    @SysLog(title="\u9898\u76ee\u5bfc\u5165", businessType=BusinessType.IMPORT)
    public Result<QuestionImportResult> importQuestion(@RequestBody QuestionExportFrom form) {
        return Result.ok((Object)this.questionService.importQuestion(form.getRepoId(), form.getText(), form.getMasteryLevel(), form.getBelong()));
    }

    @RequestMapping(value={"/uploadImageForUE/{uploadType}"})
    @PreAuthorize(value="hasAnyAuthority('questions-uploadImageForUE')")
    public Object uploadImageForUE(@PathVariable(value="uploadType") Integer uploadType, @RequestParam(value="action") String action, MultipartFile file) {
        return this.questionService.uploadImageForUE(action, file, uploadType);
    }

    @PostMapping(value={"/getAutoType"})
    @PreAuthorize(value="hasAnyAuthority('questions-getAutoType')")
    public List<ExaminationAutoTypeDTO> getAutoType(@RequestBody List<Long> catalogueIds) {
        return this.questionService.getAutoType(catalogueIds);
    }

    @GetMapping(value={"/groupByType"})
    @PreAuthorize(value="hasAnyAuthority('questions-groupByType')")
    public Result<List<HashMap<String, Integer>>> groupByType(String subjectCode) {
        return Result.ok((Object)this.questionService.groupByType(subjectCode));
    }

    @GetMapping(value={"/getAutoTypeBySubject"})
    public Result<List<ExaminationAutoTypeDTO>> getAutoTypeBySubject(String subjectCode) {
        return Result.ok((Object)this.questionService.getAutoTypeBySubject(subjectCode));
    }

    @GetMapping(value={"/getTotalCount"})
    @PreAuthorize(value="hasAnyAuthority('questions-getTotalCount')")
    public Result<String> getTotalCount(String subjectCode) {
        LambdaQueryWrapper qw = new LambdaQueryWrapper();
        Boolean isPass = Boolean.TRUE;
        long count1 = this.questionService.countBySubject(Boolean.TRUE, isPass, subjectCode);
        qw.clear();
        long count2 = this.questionService.countBySubject(Boolean.FALSE, isPass, subjectCode);
        String s = String.format("%s,%s,%s", count1 + count2, count1, count2);
        return Result.ok((Object)s);
    }

    @PutMapping(value={"/approve"})
    @SysLog(title="\u5ba1\u6838\u8bd5\u9898", businessType=BusinessType.UPDATE)
    @PreAuthorize(value="hasAnyAuthority('questions-approve')")
    public Result approve(@RequestBody QuestionApproveDto dto) {
        this.questionService.approve(dto);
        return Result.ok();
    }

    @GetMapping(value={"/getMaxSerialNumber/{repoId}"})
    public Result<String> getMaxSerialNumber(@PathVariable(value="repoId") Long repoId) {
        String maxSerialNumber = this.questionService.getMaxSerialNumber(repoId);
        return Result.ok((Object)maxSerialNumber);
    }
}

