/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.QuestionFeedbackDealDto;
import com.zsy.exam.model.dto.QuestionFeedbackDto;
import com.zsy.exam.model.form.question.QuestionFeedbackQuery;
import com.zsy.exam.model.vo.QuestionFeedbackVo;
import com.zsy.exam.service.IQuestionFeedbackService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="question/feedback", description="\u8bd5\u9898\u4fe1\u606f\u53cd\u9988")
@RequestMapping(value={"/api/question/feedback"})
public class QuestionFeedbackController {
    @Autowired
    private IQuestionFeedbackService questionFeedbackService;

    @GetMapping(value={"/myPage"})
    @Operation(summary="\u6211\u7684\u53cd\u9988\u5206\u9875")
    @PreAuthorize(value="hasAnyAuthority('question-feedback-myPage')")
    public Result<Page<QuestionFeedbackVo>> myPage(Page page, QuestionFeedbackQuery query) {
        Page questionFeedbackVoPage = this.questionFeedbackService.myPage((IPage)page, query);
        return Result.success((Object)questionFeedbackVoPage);
    }

    @GetMapping(value={"/getByQuestion/{questionId}"})
    @Operation(summary="\u8bd5\u9898\u4fe1\u606f\u53cd\u9988\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('question-feedback-getByQuestion')")
    public Result<List<QuestionFeedbackVo>> getByQuestion(@PathVariable(value="questionId") Long questionId, Boolean deal) {
        List list = this.questionFeedbackService.getByQuestion(questionId, deal);
        return Result.success((Object)list);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u8bd5\u9898\u4fe1\u606f\u53cd\u9988\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('question-feedback-add')")
    public Result add(@Valid @RequestBody QuestionFeedbackDto questionFeedback) {
        this.questionFeedbackService.add(questionFeedback);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u8bd5\u9898\u4fe1\u606f\u53cd\u9988\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('question-feedback-update')")
    public Result<Integer> update(@Valid @RequestBody QuestionFeedbackDto questionFeedback) {
        Integer num = this.questionFeedbackService.modify(questionFeedback);
        return Result.success((Object)num);
    }

    @PutMapping(value={"/deal"})
    @Operation(summary="\u5904\u7406\u53cd\u9988")
    @PreAuthorize(value="hasAnyAuthority('question-feedback-deal')")
    public Result deal(@Valid @RequestBody QuestionFeedbackDealDto dto) {
        this.questionFeedbackService.deal(dto);
        return Result.success();
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u8bd5\u9898\u4fe1\u606f\u53cd\u9988\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('question-feedback-delete')")
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.questionFeedbackService.remove(ids);
        return Result.success();
    }
}

