/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.RoleListDTO;
import com.zsy.exam.model.dto.RoleMenuUpdateDTO;
import com.zsy.exam.model.entity.Role;
import com.zsy.exam.model.vo.MenuRoleListVO;
import com.zsy.exam.model.vo.RoleVO;
import com.zsy.exam.service.IRoleService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="role", description="\u89d2\u8272\u7ba1\u7406")
@RequestMapping(value={"/role"})
public class RoleController {
    @Autowired
    private IRoleService roleService;

    @GetMapping(value={"/detail"})
    @Operation(summary="\u8be6\u60c5")
    @PreAuthorize(value="hasAnyAuthority('role-detail')")
    public Result<Role> getRole(@RequestParam(value="id") Long id) {
        Role roleOne = this.roleService.getRole(id);
        return Result.success((Object)roleOne);
    }

    @GetMapping(value={"/page"})
    @Operation(summary="\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('role-page')")
    public Result<IPage<RoleVO>> getAllRole(Page page, RoleListDTO dto) {
        IPage roleList = this.roleService.getAllRole(page, dto);
        return Result.success((Object)roleList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('role-add')")
    public Result add(@Valid @RequestBody Role role) {
        this.roleService.add(role);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('role-update')")
    public Result<Integer> update(@Valid @RequestBody Role role) {
        Integer num = this.roleService.modify(role);
        return Result.success((Object)num);
    }

    @GetMapping(value={"/delete"})
    @Operation(summary="\u5220\u9664(\u5355\u4e2a\u6761\u76ee)")
    @PreAuthorize(value="hasAnyAuthority('role-delete')")
    public Result remove(@NotBlank(message="{required}") @NotBlank(message="{required}") String ids) {
        this.roleService.remove(ids);
        return Result.success();
    }

    @GetMapping(value={"/getMenu"})
    @Operation(summary="\u83b7\u53d6\u89d2\u8272\u5bf9\u5e94\u83dc\u5355")
    @PreAuthorize(value="hasAnyAuthority('role-getMenu')")
    public Result<List<MenuRoleListVO>> getRoleMenu(Long id) {
        List roleMenuList = this.roleService.getRoleMenuList(id);
        return Result.success((Object)roleMenuList);
    }

    @PostMapping(value={"/updateRoleMenu"})
    @Operation(summary="\u4fee\u6539\u89d2\u8272\u5bf9\u5e94\u83dc\u5355")
    @PreAuthorize(value="hasAnyAuthority('role-updateRoleMenu')")
    public Result updateRoleMenu(@RequestBody RoleMenuUpdateDTO dto) {
        this.roleService.updateRoleMenu(dto);
        return Result.success();
    }
}

