/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.School;
import com.zsy.exam.service.ISchoolService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/school"})
public class SchoolController {
    @Autowired
    private ISchoolService schoolService;

    @GetMapping(value={"/detail"})
    @Operation(summary="\u5b66\u6821\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('school-detail')")
    public Result<School> getSchool(@RequestParam(value="id") Long id) {
        School schoolOne = this.schoolService.getSchool(id);
        return Result.success((Object)schoolOne);
    }

    @GetMapping(value={"/page"})
    @Operation(summary="\u5b66\u6821\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('school-page')")
    public Result<IPage<School>> getAllSchool(Page page, Long examAreaId) {
        IPage schoolList = this.schoolService.getAllSchool(page, examAreaId);
        return Result.success((Object)schoolList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u5b66\u6821\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('school-add')")
    public Result add(@Valid @RequestBody School school) {
        this.schoolService.add(school);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u5b66\u6821\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('school-update')")
    public Result<Integer> update(@Valid @RequestBody School school) {
        Integer num = this.schoolService.modify(school);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u5b66\u6821\u5220\u9664(\u5355\u4e2a\u6761\u76ee)")
    @PreAuthorize(value="hasAnyAuthority('school-delete')")
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.schoolService.remove(ids);
        return Result.success();
    }
}

