/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.vo.score.ExamAnalyzeListVO;
import com.zsy.exam.model.vo.score.ExamAnalyzeVO;
import com.zsy.exam.model.vo.score.UserScoreVO;
import com.zsy.exam.service.IExamQuAnswerService;
import com.zsy.exam.service.IExamService;
import com.zsy.exam.service.IStatService;
import com.zsy.exam.service.IUserExamsScoreService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.constraints.NotNull;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/score"})
@Tag(name="\u6210\u7ee9\u7ba1\u7406", description="\u6210\u7ee9\u7ba1\u7406")
public class ScoreController {
    @Resource
    private IStatService iStatService;
    @Resource
    private IUserExamsScoreService iUserExamsScoreService;
    @Resource
    private IExamQuAnswerService iExamQuAnswerService;
    @Resource
    private IExamService examService;

    @GetMapping(value={"/analyze"})
    @PreAuthorize(value="hasAnyAuthority('score-analyze')")
    @Operation(summary="\u8003\u8bd5\u6210\u7ee9\u5206\u6790")
    public Result<ExamAnalyzeVO> analyze(@RequestParam(value="examId") @NotNull Long examId, @RequestParam(value="clbumId", required=false) Long clbumId) {
        return this.examService.analyze(examId, clbumId);
    }

    @GetMapping(value={"/paging"})
    @PreAuthorize(value="hasAnyAuthority('score-paging')")
    @Operation(summary="\u5206\u9875\u83b7\u53d6\u8003\u8bd5\u6210\u7ee9\u5217\u8868")
    public Result<Page<ExamAnalyzeListVO>> pagingExamAnalyze(Page page, @RequestParam(value="realName", required=false) String title, String startTime, String endTime, String subjectCode) {
        return this.iUserExamsScoreService.pagingExamAnalyzeList(page, title, startTime, endTime, subjectCode);
    }

    @GetMapping(value={"/detail/paging"})
    @PreAuthorize(value="hasAnyAuthority('score-detail-paging')")
    @Operation(summary="\u5206\u9875\u83b7\u53d6\u5b66\u751f\u8003\u8bd5\u6210\u7ee9\u4fe1\u606f")
    public Result<IPage<UserScoreVO>> pagingDetailScore(@RequestParam(value="pageNum", required=false, defaultValue="1") Integer pageNum, @RequestParam(value="pageSize", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="clbumId", required=false) Long clbumId, @RequestParam(value="examId") Long examId, @RequestParam(value="realName", required=false) String realName, @RequestParam(value="studyCode", required=false) String studyCode, @RequestParam(value="realNameOrStudyCode", required=false) String realNameOrStudyCode, @RequestParam(value="isAttend", required=false) Boolean isAttend) {
        return this.iUserExamsScoreService.pagingScore(pageNum, pageSize, clbumId, examId, realName, studyCode, realNameOrStudyCode, isAttend);
    }

    @GetMapping(value={"/reset/count"})
    @PreAuthorize(value="hasAnyAuthority('score-detail-paging')")
    @Operation(summary="\u91cd\u7f6e\u5207\u5c4f\u8ba1\u6570\u5e76\u63d0\u4f9b\u539f\u56e0")
    public Result resetCount(@RequestParam(value="scoreId") Long scoreId, @RequestParam(value="reason") String reason) {
        return this.iUserExamsScoreService.resetCount(scoreId, reason);
    }

    @GetMapping(value={"/set/cheater"})
    @PreAuthorize(value="hasAnyAuthority('score-detail-paging')")
    @Operation(summary="\u8bbe\u7f6e\u4e3a\u4f5c\u5f0a\u8005\u5e76\u63d0\u4f9b\u539f\u56e0")
    public Result setCheater(@RequestParam(value="scoreId") Long scoreId, @RequestParam(value="reason") String reason) {
        return this.iUserExamsScoreService.setCheater(scoreId, reason);
    }

    @GetMapping(value={"/export"})
    @PreAuthorize(value="hasAnyAuthority('score-export')")
    @Operation(summary="\u6210\u7ee9\u5bfc\u51fa")
    public void scoreExport(HttpServletResponse response, @RequestParam(value="examId") Long examId, @RequestParam(value="clbumId", required=false) Long clbumId) {
        this.iUserExamsScoreService.exportScores(response, examId, clbumId);
    }
}

