/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.SensitiveWordsDTO;
import com.zsy.exam.model.entity.SensitiveWords;
import com.zsy.exam.model.vo.SensitiveWordsVO;
import com.zsy.exam.service.ISensitiveWordsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Tag(name="sensitive-words", description="\u654f\u611f\u8bcd")
@RequestMapping(value={"/api/sensitive-words"})
public class SensitiveWordsController {
    @Autowired
    private ISensitiveWordsService sensitiveWordsService;

    @GetMapping(value={"/page"})
    @Operation(summary="\u654f\u611f\u8bcd\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('sensitive-words-page')")
    public Result<Page<SensitiveWordsVO>> getAllSensitiveWords(Page page, SensitiveWordsDTO dto) {
        Page sensitiveWordsList = this.sensitiveWordsService.getAllSensitiveWords(page, dto);
        return Result.success((Object)sensitiveWordsList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u654f\u611f\u8bcd\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('sensitive-words-add')")
    public Result add(@Valid @RequestBody SensitiveWords sensitiveWords) {
        this.sensitiveWordsService.add(sensitiveWords);
        return Result.success();
    }

    @PostMapping(value={"/update"})
    @Operation(summary="\u654f\u611f\u8bcd\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('sensitive-words-update')")
    public Result<Integer> update(@Valid @RequestBody SensitiveWords sensitiveWords) {
        Integer num = this.sensitiveWordsService.modify(sensitiveWords);
        return Result.success((Object)num);
    }

    @GetMapping(value={"/delete"})
    @Operation(summary="\u654f\u611f\u8bcd\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('sensitive-words-delete')")
    public Result remove(String ids) {
        this.sensitiveWordsService.remove(ids);
        return Result.success();
    }

    @PostMapping(value={"importTxt"})
    @SysLog(title="\u5bfc\u5165\u654f\u611f\u8bcd", businessType=BusinessType.IMPORT)
    @PreAuthorize(value="hasAnyAuthority('sensitive-words-importTxt')")
    public Result importExcel(@RequestParam(value="file") MultipartFile file) {
        this.sensitiveWordsService.importTxt(file);
        return Result.success();
    }
}

