/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.handler.WeChatLoginHandler;
import com.zsy.exam.model.dto.wx.BindSocialDTO;
import com.zsy.exam.model.entity.User;
import com.zsy.exam.model.vo.wx.BindResultVO;
import com.zsy.exam.model.vo.wx.SocialLoginTypeVO;
import com.zsy.exam.service.ISocialLoginService;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"social"})
public class SocialController {
    private static final Logger log = LoggerFactory.getLogger(SocialController.class);
    @Autowired
    private ISocialLoginService socialLoginService;
    @Autowired
    private WeChatLoginHandler weChatLoginHandler;

    @GetMapping(value={"identify"})
    @Operation(summary="\u83b7\u53d6\u7b2c\u4e09\u65b9\u767b\u5f55\u552f\u4e00\u6807\u8bc6")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result<String> identisocialLoginTypeListfy(@RequestParam(value="state", required=false) String state, @RequestParam(value="authCode") String authCode) {
        return Result.ok((Object)this.socialLoginService.identify(state, authCode));
    }

    @GetMapping(value={"getUserInfo"})
    @Operation(summary="\u6839\u636e\u7b2c\u4e09\u65b9\u767b\u5f55\u552f\u4e00\u6807\u8bc6\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result<User> getUserInfo(@RequestParam(value="state", required=false) String state, @RequestParam(value="identify") String identify) {
        return Result.ok((Object)this.socialLoginService.getUserInfo(state, identify));
    }

    @PostMapping(value={"bind"})
    @Operation(summary="\u7ed1\u5b9a\u793e\u4ea4\u8d26\u53f7")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result<BindResultVO> bind(@Validated @RequestBody BindSocialDTO bindSocialDto) {
        return Result.ok((Object)this.socialLoginService.bind(bindSocialDto));
    }

    @PostMapping(value={"unbind"})
    @Operation(summary="\u89e3\u7ed1\u793e\u4ea4\u8d26\u53f7 \u53ea\u7528\u4f20\u5165state")
    @SysLog(title="\u89e3\u7ed1\u793e\u4ea4\u8d26\u53f7", businessType=BusinessType.OTHER)
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result<Boolean> unbind(@Validated @RequestBody BindSocialDTO bindSocialDto) {
        return Result.ok((Object)this.socialLoginService.unbind(bindSocialDto));
    }

    @Operation(summary="\u67e5\u8be2\u793e\u4ea4\u767b\u5f55\u65b9\u5f0f\u5217\u8868")
    @GetMapping(value={"/socialLoginTypeList"})
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result<List<SocialLoginTypeVO>> getSocialLoginTypeList() {
        return Result.ok((Object)this.socialLoginService.getSocialLoginTypeList());
    }
}

