/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.Specialty;
import com.zsy.exam.service.ISpecialtyService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Tag(name="specialty", description="\u4e13\u4e1a")
@RequestMapping(value={"/specialty"})
public class SpecialtyController {
    @Autowired
    private ISpecialtyService specialtyService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u4e13\u4e1a\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('specialty-selectOne')")
    public Result<Specialty> getSpecialty(@RequestParam(value="id") Long id) {
        Specialty specialtyOne = this.specialtyService.getSpecialty(id);
        return Result.success((Object)specialtyOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u4e13\u4e1a\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('specialty-listAll')")
    public Result<Page<List<Specialty>>> getAllSpecialty(Page page, @RequestParam(value="name", required=false) String name, @RequestParam(value="code", required=false) String code, @RequestParam(value="enable", required=false) Boolean enable) {
        Page specialtyList = this.specialtyService.getAllSpecialty(page, name, code, enable);
        return Result.success((Object)specialtyList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u4e13\u4e1a\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('specialty-add')")
    @SysLog(title="\u4e13\u4e1a\u65b0\u589e", businessType=BusinessType.INSERT)
    public Result add(@Valid @RequestBody Specialty specialty) {
        this.specialtyService.add(specialty);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u4e13\u4e1a\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('specialty-update')")
    @SysLog(title="\u65b0\u589e\u6559\u5e08", businessType=BusinessType.UPDATE)
    public Result<Integer> update(@Valid @RequestBody Specialty specialty) {
        Integer num = this.specialtyService.modify(specialty);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u4e13\u4e1a\u5220\u9664(\u5355\u4e2a\u6761\u76ee)")
    @PreAuthorize(value="hasAnyAuthority('specialty-delete')")
    @SysLog(title="\u4e13\u4e1a\u5220\u9664", businessType=BusinessType.DELETE)
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.specialtyService.remove(ids);
        return Result.success();
    }

    @PostMapping(value={"importSpecialty"})
    @PreAuthorize(value="hasAnyAuthority('specialty-importSpecialty')")
    @SysLog(title="\u5bfc\u5165\u4e13\u4e1a", businessType=BusinessType.IMPORT)
    public Result importSpecialty(@RequestParam(value="file") MultipartFile file) throws Exception {
        this.specialtyService.importSpecialty(file);
        return Result.success();
    }

    @GetMapping(value={"exportSpecialty"})
    @PreAuthorize(value="hasAnyAuthority('specialty-exportSpecialty')")
    public Result exportSpecialty(HttpServletResponse response, String name, String code, Boolean enable) {
        this.specialtyService.exportSpecialty(response, name, code, enable);
        return Result.success();
    }

    @GetMapping(value={"syncGradeAndSpec"})
    @PreAuthorize(value="hasAnyAuthority('specialty-syncGradeAndSpec')")
    public Result syncGradeAndSpec() {
        this.specialtyService.syncGradeAndSpec();
        return Result.success();
    }
}

