/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.StaffAddDTO;
import com.zsy.exam.model.dto.StaffListDTO;
import com.zsy.exam.model.dto.StaffRoleDTO;
import com.zsy.exam.model.dto.UpdateStatusDTO;
import com.zsy.exam.model.entity.Staff;
import com.zsy.exam.model.vo.StaffListVO;
import com.zsy.exam.service.IStaffService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/staff"})
public class StaffController {
    @Autowired
    private IStaffService staffService;

    @GetMapping(value={"/detail"})
    @Operation(summary="\u8be6\u60c5")
    @PreAuthorize(value="hasAnyAuthority('staff-detail')")
    public Result<StaffAddDTO> getStaff(Long id) {
        StaffAddDTO staffOne = this.staffService.detail(id);
        return Result.success((Object)staffOne);
    }

    @GetMapping(value={"/page"})
    @Operation(summary="\u6559\u804c\u5de5\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('staff-page')")
    public Result<IPage<StaffListVO>> getAllStaff(Page page, StaffListDTO dto) {
        IPage staffList = this.staffService.pageList(page, dto);
        return Result.success((Object)staffList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('staff-add')")
    @SysLog(title="\u65b0\u589e\u6559\u5e08", businessType=BusinessType.INSERT)
    public Result add(@RequestBody @Validated StaffAddDTO dto) {
        this.staffService.add(dto);
        return Result.success();
    }

    @PostMapping(value={"/update"})
    @Operation(summary="\u7f16\u8f91")
    @PreAuthorize(value="hasAnyAuthority('staff-update')")
    @SysLog(title="\u4fee\u6539\u6559\u5e08", businessType=BusinessType.UPDATE)
    public Result update(@RequestBody @Validated StaffAddDTO dto) {
        this.staffService.update(dto);
        return Result.success();
    }

    @PostMapping(value={"/update-status"})
    @Operation(summary="\u7f16\u8f91\u72b6\u6001")
    @PreAuthorize(value="hasAnyAuthority('staff-update-status')")
    public Result updateStatus(@RequestBody UpdateStatusDTO dto) {
        if (dto.getId() == null) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        Staff staff = (Staff)this.staffService.getById((Serializable)dto.getId());
        dto.setUserId(staff.getUserId());
        this.staffService.updateStatus(dto);
        return Result.success();
    }

    @GetMapping(value={"/delete"})
    @Operation(summary="\u5220\u9664")
    @PreAuthorize(value="hasAnyAuthority('staff-delete')")
    public Result delete(String ids) {
        this.staffService.delete(ids);
        return Result.success();
    }

    @GetMapping(value={"/myclbum"})
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u6559\u5e08\u6559\u6388\u79d1\u76ee\u7684\u73ed\u7ea7(\u7ba1\u7406\u5458\u770b\u6240\u6709)")
    @PreAuthorize(value="hasAnyAuthority('staff-myclbum')")
    public Result getMyClbum() {
        List myClbum = this.staffService.getMyClbum();
        return Result.success((Object)myClbum);
    }

    @PostMapping(value={"importStaff"})
    @PreAuthorize(value="hasAnyAuthority('staff-importStaff')")
    @SysLog(title="\u5bfc\u5165\u6559\u5e08", businessType=BusinessType.IMPORT)
    public Result importStaff(@RequestParam(value="file") MultipartFile file) throws Exception {
        this.staffService.importStaff(file);
        return Result.success();
    }

    @GetMapping(value={"exportStaff"})
    @PreAuthorize(value="hasAnyAuthority('staff-exportStaff')")
    public Result exportStaff(HttpServletResponse response, StaffListDTO dto) {
        this.staffService.exportStaff(response, dto);
        return Result.success();
    }

    @GetMapping(value={"exportStaffTemp"})
    public Result exportStaffTemp(HttpServletResponse response) {
        this.staffService.exportStaffTemp(response);
        return Result.success();
    }

    @PostMapping(value={"bind-role"})
    @PreAuthorize(value="hasAnyAuthority('bind-role')")
    public Result bindUserRoleId(@RequestBody StaffRoleDTO dto) {
        this.staffService.bindUserRole(dto);
        return Result.success();
    }
}

