/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.exception.AppException;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.StudentAddDTO;
import com.zsy.exam.model.dto.StudentConditionDTO;
import com.zsy.exam.model.dto.StudentSimpleDTO;
import com.zsy.exam.model.dto.UpdateStatusDTO;
import com.zsy.exam.model.entity.Student;
import com.zsy.exam.model.vo.ExamStudentScoreAllVO;
import com.zsy.exam.model.vo.ExamStudentScoreVO;
import com.zsy.exam.model.vo.StudentPlusVO;
import com.zsy.exam.service.IStudentService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/student"})
@Tag(name="\u5b66\u751f\u7ba1\u7406", description="\u5b66\u751f\u7ba1\u7406")
public class StudentController {
    @Autowired
    private IStudentService studentService;

    @GetMapping(value={"page"})
    @PreAuthorize(value="hasAnyAuthority('student-page')")
    public Result<IPage<StudentSimpleDTO>> page(StudentConditionDTO condition, Page<StudentSimpleDTO> page) {
        IPage result = this.studentService.selectPage(condition, page);
        return Result.success((Object)result);
    }

    @PostMapping(value={"add"})
    @SysLog(title="\u65b0\u589e\u5b66\u751f", businessType=BusinessType.INSERT)
    @PreAuthorize(value="hasAnyAuthority('student-add')")
    public Result add(@Validated @RequestBody StudentAddDTO dto) {
        this.studentService.add(dto);
        return Result.success();
    }

    @PostMapping(value={"update"})
    @SysLog(title="\u4fee\u6539\u5b66\u751f", businessType=BusinessType.UPDATE)
    @PreAuthorize(value="hasAnyAuthority('student-update')")
    public Result update(@Validated @RequestBody StudentAddDTO dto) {
        this.studentService.update(dto);
        return Result.success();
    }

    @PostMapping(value={"/update-status"})
    @Operation(summary="\u7f16\u8f91\u72b6\u6001")
    @PreAuthorize(value="hasAnyAuthority('student-update-status')")
    public Result updateStatus(@RequestBody UpdateStatusDTO dto) {
        if (dto.getId() == null) {
            throw new AppException("\u53c2\u6570\u9519\u8bef");
        }
        Student student = (Student)this.studentService.getById((Serializable)dto.getId());
        dto.setUserId(student.getUserId());
        this.studentService.updateStatus(dto);
        return Result.success();
    }

    @GetMapping(value={"detail"})
    @PreAuthorize(value="hasAnyAuthority('student-detail')")
    public Result<StudentAddDTO> detail(Long id) {
        StudentAddDTO detail = this.studentService.detail(id);
        return Result.success((Object)detail);
    }

    @GetMapping(value={"delete"})
    @PreAuthorize(value="hasAnyAuthority('student-delete')")
    public Result delete(String ids) {
        this.studentService.delete(ids);
        return Result.success();
    }

    @GetMapping(value={"exportStudent"})
    @PreAuthorize(value="hasAnyAuthority('student-exportStudent')")
    public Result exportStudent(HttpServletResponse response, StudentConditionDTO condition) {
        this.studentService.exportStudent(response, condition);
        return Result.success();
    }

    @GetMapping(value={"exportStudentTemp"})
    public Result exportStudentTemp(HttpServletResponse response) {
        this.studentService.exportStudentTemp(response);
        return Result.success();
    }

    @PostMapping(value={"importStudent"})
    @PreAuthorize(value="hasAnyAuthority('student-importStudent')")
    @SysLog(title="\u5bfc\u5165\u5b66\u751f", businessType=BusinessType.IMPORT)
    public Result importStudent(@RequestParam(value="file") MultipartFile file) throws Exception {
        this.studentService.importStudent(file);
        return Result.success();
    }

    @Operation(summary="\u5b66\u751f\u5206\u6790")
    @GetMapping(value={"/analysis"})
    @PreAuthorize(value="hasAnyAuthority('student-analysis')")
    public Result<ExamStudentScoreVO> analysis(Integer type, String subjectCode, Long userId) {
        ExamStudentScoreVO vo = this.studentService.studentAnalysis(type, subjectCode, userId);
        return Result.success((Object)vo);
    }

    @Operation(summary="\u5b66\u751f\u5206\u6790-\u603b\u79d1\u76ee")
    @GetMapping(value={"/total-analysis"})
    @PreAuthorize(value="hasAnyAuthority('student-total-analysis')")
    public Result<List<ExamStudentScoreAllVO>> allAnalysis(Integer type, Long userId) {
        List list = this.studentService.studentTotalAnalysis(type, userId);
        return Result.success((Object)list);
    }

    @PostMapping(value={"/listByClbumList"})
    @PreAuthorize(value="hasAnyAuthority('student-listByClbumList')")
    @Operation(summary="\u83b7\u53d6\u73ed\u7ea7\u5217\u8868\u7684\u6240\u6709\u5b66\u751f")
    public Result<List<StudentPlusVO>> listByClbumList(@RequestBody List<Long> clbumList) {
        return Result.success((Object)this.studentService.listByClbumList(clbumList));
    }
}

