/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.SubjectExerciseNumberDto;
import com.zsy.exam.model.dto.SubjectUpdatePaperCountDTO;
import com.zsy.exam.model.entity.Subject;
import com.zsy.exam.model.vo.subject.SubjectForTeacherVO;
import com.zsy.exam.model.vo.subject.SubjectVO;
import com.zsy.exam.service.ISubjectService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/subject"})
@Tag(name="\u79d1\u76ee\u7ba1\u7406", description="\u79d1\u76ee\u7ba1\u7406")
public class SubjectController {
    @Autowired
    private ISubjectService subjectService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u79d1\u76ee\u7ba1\u7406\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('subject-selectOne')")
    public Result<Subject> getSubject(@RequestParam(value="id") Long id) {
        Subject subjectOne = this.subjectService.getSubject(id);
        return Result.success((Object)subjectOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u79d1\u76ee\u7ba1\u7406\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('subject-listAll')")
    public Result<Page<SubjectVO>> getAllSubject(Page page, @RequestParam(value="name", required=false) String name, @RequestParam(value="code", required=false) String code, @RequestParam(value="enable", required=false) Boolean enable, @RequestParam(value="examAreaId", required=false) Long examAreaId) {
        Page subjectList = this.subjectService.getAllSubject(page, name, code, enable, examAreaId);
        return Result.success((Object)subjectList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u79d1\u76ee\u7ba1\u7406\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('subject-add')")
    @SysLog(title="\u79d1\u76ee\u7ba1\u7406\u65b0\u589e", businessType=BusinessType.INSERT)
    public Result add(@Valid @RequestBody Subject subject) {
        this.subjectService.add(subject);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u79d1\u76ee\u7ba1\u7406\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('subject-update')")
    @SysLog(title="\u79d1\u76ee\u7ba1\u7406\u4fee\u6539", businessType=BusinessType.UPDATE)
    public Result<Integer> update(@Valid @RequestBody Subject subject) {
        Integer num = this.subjectService.modify(subject);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u79d1\u76ee\u7ba1\u7406\u5220\u9664(\u5355\u4e2a\u6761\u76ee)")
    @PreAuthorize(value="hasAnyAuthority('subject-delete')")
    @SysLog(title="\u79d1\u76ee\u7ba1\u7406\u5220\u9664", businessType=BusinessType.DELETE)
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.subjectService.remove(ids);
        return Result.success();
    }

    @GetMapping(value={"/listForStudent"})
    @Operation(summary="\u79d1\u76ee\u7ba1\u7406\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('subject-listForStudent')")
    public Result<List<Subject>> listForStudent() {
        List subjectList = this.subjectService.listForStudent();
        return Result.success((Object)subjectList);
    }

    @GetMapping(value={"/listForTeacher"})
    @Operation(summary="\u8001\u5e08\u6559\u6388\u7684\u79d1\u76ee")
    @PreAuthorize(value="hasAnyAuthority('subject-listForTeacher')")
    public Result<List<SubjectForTeacherVO>> listForTeacher(@RequestParam(value="userId", required=false) String userId, @RequestParam(value="subjectId", required=false) String subjectId) {
        List subjectForTeacherVOList = this.subjectService.listForTeacher(userId, subjectId);
        return Result.success((Object)subjectForTeacherVOList);
    }

    @PutMapping(value={"/exerciseNumber"})
    @Operation(summary="\u4fee\u6539\u7ec3\u4e60\u9898\u7684\u6570\u91cf")
    @PreAuthorize(value="hasAnyAuthority('subject-exerciseNumber')")
    public Result exerciseNumber(@RequestBody SubjectExerciseNumberDto dto) {
        this.subjectService.updateExerciseNumber(dto);
        return Result.success();
    }

    @GetMapping(value={"/selectByCode/{code}"})
    @Operation(summary="\u79d1\u76ee\u7ba1\u7406\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('subject-selectByCode')")
    public Result<Subject> getSubjectByCode(@PathVariable(value="code") String code) {
        Subject subjectOne = this.subjectService.getByCode(code);
        return Result.success((Object)subjectOne);
    }

    @PostMapping(value={"/updatePaperCount"})
    @Operation(summary="\u79d1\u76ee\u7ba1\u7406\u4fee\u6539\u8bd5\u5377\u7ec4\u9898\u6570\u91cf")
    @PreAuthorize(value="hasAnyAuthority('subject-updatePaperCount')")
    @SysLog(title="\u79d1\u76ee\u7ba1\u7406\u4fee\u6539\u8bd5\u5377\u7ec4\u9898\u6570\u91cf", businessType=BusinessType.UPDATE)
    public Result updatePaperCount(@RequestBody SubjectUpdatePaperCountDTO dto) {
        this.subjectService.updatePaperCount(dto);
        return Result.success();
    }
}

