/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.SubjectSpecialtyMapping;
import com.zsy.exam.service.ISubjectSpecialtyMappingService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="subject-specialty-mapping", description="\u79d1\u76ee\u4e13\u4e1a\u6620\u5c04\u7ba1\u7406")
@RequestMapping(value={"/api/subject-specialty-mapping"})
public class SubjectSpecialtyMappingController {
    @Autowired
    private ISubjectSpecialtyMappingService subjectSpecialtyMappingService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u79d1\u76ee\u4e13\u4e1a\u6620\u5c04\u7ba1\u7406\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('subject-specialty-mapping-selectOne')")
    public Result<SubjectSpecialtyMapping> getSubjectSpecialtyMapping(@RequestParam(value="id") Long id) {
        SubjectSpecialtyMapping subjectSpecialtyMappingOne = this.subjectSpecialtyMappingService.getSubjectSpecialtyMapping(id);
        return Result.success((Object)subjectSpecialtyMappingOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u79d1\u76ee\u4e13\u4e1a\u6620\u5c04\u7ba1\u7406\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('subject-specialty-mapping-listAll')")
    public Result<Page<SubjectSpecialtyMapping>> getAllSubjectSpecialtyMapping(Page page) {
        Page subjectSpecialtyMappingList = this.subjectSpecialtyMappingService.getAllSubjectSpecialtyMapping(page);
        return Result.success((Object)subjectSpecialtyMappingList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u79d1\u76ee\u4e13\u4e1a\u6620\u5c04\u7ba1\u7406\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('subject-specialty-mapping-add')")
    public Result add(@Valid @RequestBody SubjectSpecialtyMapping subjectSpecialtyMapping) {
        this.subjectSpecialtyMappingService.add(subjectSpecialtyMapping);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u79d1\u76ee\u4e13\u4e1a\u6620\u5c04\u7ba1\u7406\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('subject-specialty-mapping-update')")
    public Result<Integer> update(@Valid @RequestBody SubjectSpecialtyMapping subjectSpecialtyMapping) {
        Integer num = this.subjectSpecialtyMappingService.modify(subjectSpecialtyMapping);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u79d1\u76ee\u4e13\u4e1a\u6620\u5c04\u7ba1\u7406\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('subject-specialty-mapping-delete')")
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.subjectSpecialtyMappingService.remove(ids);
        return Result.success();
    }
}

