/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.SysParam;
import com.zsy.exam.service.ISysParamService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="sys-param", description="\u7cfb\u7edf\u914d\u7f6e\u8868")
@RequestMapping(value={"/api/sys-param"})
public class SysParamController {
    @Autowired
    private ISysParamService sysParamService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u7cfb\u7edf\u914d\u7f6e\u8868\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('sys-param-selectOne')")
    public Result<SysParam> getSysParam(@RequestParam(value="id") Long id) {
        SysParam sysParamOne = this.sysParamService.getSysParam(id);
        return Result.success((Object)sysParamOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u7cfb\u7edf\u914d\u7f6e\u8868\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('sys-param-listAll')")
    public Result<Page<SysParam>> getAllSysParam(Page page) {
        Page sysParamList = this.sysParamService.getAllSysParam(page);
        return Result.success((Object)sysParamList);
    }

    @GetMapping(value={"/getByType/{type}"})
    @Operation(summary="\u7cfb\u7edf\u914d\u7f6e\u8868\u67e5\u8be2")
    public Result<SysParam> getByType(@PathVariable(value="type") String type) {
        SysParam sysParam = this.sysParamService.getByType(type);
        return Result.success((Object)sysParam);
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u7cfb\u7edf\u914d\u7f6e\u8868\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('sys-param-update')")
    public Result<Integer> update(@Valid @RequestBody SysParam sysParam) {
        Integer num = this.sysParamService.modify(sysParam);
        return Result.success((Object)num);
    }

    @GetMapping(value={"/getCurrentTime"})
    @Operation(summary="\u83b7\u53d6\u670d\u52a1\u5668\u5f53\u524d\u65f6\u95f4")
    public Result<String> getCurrentTime() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String date = dateFormat.format(new Date());
        return Result.success((String)"", (Object)date);
    }
}

