/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.annotation.SysLog;
import com.zsy.exam.annotation.enums.BusinessType;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.Term;
import com.zsy.exam.service.ITermService;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/term"})
public class TermController {
    @Autowired
    private ITermService termService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u5b66\u671f\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('term-selectOne')")
    public Result<Term> getTerm(@RequestParam(value="id") Long id) {
        Term termOne = this.termService.getTerm(id);
        return Result.success((Object)termOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u5b66\u671f\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('term-listAll')")
    public Result<Page<List<Term>>> getAllTerm(Page page, @RequestParam(value="name", required=false) String name, @RequestParam(value="code", required=false) String code) {
        Page termList = this.termService.getAllTerm(page, name, code);
        return Result.success((Object)termList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u5b66\u671f\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('term-add')")
    @SysLog(title="\u5b66\u671f\u65b0\u589e", businessType=BusinessType.INSERT)
    public Result add(@Valid @RequestBody Term term) {
        this.termService.add(term);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u5b66\u671f\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('term-update')")
    @SysLog(title="\u5b66\u671f\u4fee\u6539", businessType=BusinessType.UPDATE)
    public Result<Integer> update(@Valid @RequestBody Term term) {
        Integer num = this.termService.modify(term);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u5b66\u671f\u5220\u9664(\u5355\u4e2a\u6761\u76ee)")
    @PreAuthorize(value="hasAnyAuthority('term-delete')")
    @SysLog(title="\u5b66\u671f\u4fee\u6539", businessType=BusinessType.DELETE)
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.termService.remove(ids);
        return Result.success();
    }
}

