/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.ThirdConfig;
import com.zsy.exam.service.IThirdConfigService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Tag(name="third-config", description="\u4e09\u65b9\u914d\u7f6e")
@RequestMapping(value={"/third-config"})
public class ThirdConfigController {
    @Autowired
    private IThirdConfigService thirdConfigService;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u4e09\u65b9\u914d\u7f6e\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result<ThirdConfig> getThirdConfig(@RequestParam(value="id") Long id) {
        ThirdConfig thirdConfigOne = this.thirdConfigService.getThirdConfig(id);
        return Result.success((Object)thirdConfigOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u4e09\u65b9\u914d\u7f6e\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result<Page<List<ThirdConfig>>> getAllThirdConfig(Page page) {
        Page thirdConfigList = this.thirdConfigService.getAllThirdConfig(page);
        return Result.success((Object)thirdConfigList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u4e09\u65b9\u914d\u7f6e\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result add(@Valid @RequestBody ThirdConfig thirdConfig) {
        this.thirdConfigService.add(thirdConfig);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u4e09\u65b9\u914d\u7f6e\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result<Integer> update(@Valid @RequestBody ThirdConfig thirdConfig) {
        Integer num = this.thirdConfigService.modify(thirdConfig);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u4e09\u65b9\u914d\u7f6e\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u4f7f\u7528\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('role_teacher','role_admin')")
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.thirdConfigService.remove(ids);
        return Result.success();
    }
}

