/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import cn.hutool.core.io.resource.ResourceUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.entity.twoway.TwoWaySheet;
import com.zsy.exam.model.entity.twoway.TwoWaySheetHead;
import com.zsy.exam.model.entity.twoway.TwowayDetailTable;
import com.zsy.exam.model.vo.twoway.TwowayDetailTableErrorVO;
import com.zsy.exam.model.vo.twoway.TwowayDetailTableVO;
import com.zsy.exam.service.ITwowayDetailTableService;
import com.zsy.exam.util.MinioUtil;
import com.zsy.exam.util.TwoWayDetailTableUtils;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/twoway-detail-table"})
public class TwowayDetailTableController {
    @Autowired
    private ITwowayDetailTableService twowayDetailTableService;
    @Autowired
    private MinioUtil minioUtil;

    @GetMapping(value={"/selectOne"})
    @Operation(summary="\u53cc\u5411\u7ec6\u76ee\u8868\u67e5\u8be2\u5355\u4e2a")
    @PreAuthorize(value="hasAnyAuthority('twoway-detail-table-selectOne')")
    public Result<TwowayDetailTable> getTwowayDetailTable(@RequestParam(value="id") Long id) {
        TwowayDetailTable twowayDetailTableOne = this.twowayDetailTableService.getTwowayDetailTable(id);
        return Result.success((Object)twowayDetailTableOne);
    }

    @GetMapping(value={"/listAll"})
    @Operation(summary="\u53cc\u5411\u7ec6\u76ee\u8868\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('twoway-detail-table-listAll')")
    public Result<Page<TwowayDetailTableVO>> getAllTwowayDetailTable(Page page, @RequestParam(required=false) String subjectName) {
        Page twowayDetailTableList = this.twowayDetailTableService.getAllTwowayDetailTable(page, subjectName);
        return Result.success((Object)twowayDetailTableList);
    }

    @GetMapping(value={"/list"})
    @Operation(summary="\u53cc\u5411\u7ec6\u76ee\u8868\u6839\u636e\u6761\u4ef6\u67e5\u8be2\u5168\u90e8")
    @PreAuthorize(value="hasAnyAuthority('twoway-detail-table-list')")
    public Result<Page<TwowayDetailTable>> getAllTwowayDetailTableByParam(Page page, @RequestParam(required=false) Long termId, @RequestParam(required=false) Long subjectId, @RequestParam(required=false) Long specialtyId, @RequestParam(required=false) Long gradeId, @RequestParam(required=false) Integer type) {
        Page twowayDetailTableList = this.twowayDetailTableService.getAllTwowayDetailTableByParam(page, termId, subjectId, specialtyId, gradeId, type);
        return Result.success((Object)twowayDetailTableList);
    }

    @PostMapping(value={"/add"})
    @Operation(summary="\u53cc\u5411\u7ec6\u76ee\u8868\u65b0\u589e")
    @PreAuthorize(value="hasAnyAuthority('twoway-detail-table-add')")
    public Result add(@Valid @RequestBody TwowayDetailTable twowayDetailTable) {
        this.twowayDetailTableService.add(twowayDetailTable);
        return Result.success();
    }

    @PutMapping(value={"/update"})
    @Operation(summary="\u53cc\u5411\u7ec6\u76ee\u8868\u4fee\u6539")
    @PreAuthorize(value="hasAnyAuthority('twoway-detail-table-update')")
    public Result<Integer> update(@Valid @RequestBody TwowayDetailTable twowayDetailTable) {
        Integer num = this.twowayDetailTableService.modify(twowayDetailTable);
        return Result.success((Object)num);
    }

    @DeleteMapping(value={"/delete/{ids}"})
    @Operation(summary="\u53cc\u5411\u7ec6\u76ee\u8868\u5220\u9664(\u591a\u4e2a\u6761\u76ee\uff0c\u9017\u53f7\u5206\u9694)")
    @PreAuthorize(value="hasAnyAuthority('twoway-detail-table-delete')")
    public Result remove(@NotBlank(message="{required}") @PathVariable @NotBlank(message="{required}") String ids) {
        this.twowayDetailTableService.remove(ids);
        return Result.success();
    }

    @DeleteMapping(value={"/delete/{subjectId}/{type}"})
    @Operation(summary="\u6839\u636e\u79d1\u76ee\u5220\u9664\u53cc\u5411\u7ec6\u76ee\u8868")
    @PreAuthorize(value="hasAnyAuthority('twoway-detail-table-delete-subjectId')")
    public Result removeBySubjectId(@PathVariable Long subjectId, @PathVariable Integer type) {
        return Result.success((Object)this.twowayDetailTableService.removeBySubjectId(subjectId, type));
    }

    @GetMapping(value={"/example"})
    @Operation(summary="\u4e0b\u8f7d\u6a21\u7248\u53cc\u5411\u7ec6\u76ee\u8868")
    @PreAuthorize(value="hasAnyAuthority('twoway-detail-table-example')")
    public void downloadExample(HttpServletResponse response) throws IOException {
        InputStream in = ResourceUtil.getStream((String)"example/\u53cc\u5411\u7ec6\u76ee\u8868\u6a21\u7248.xlsx");
        response.setContentType("application/octet-stream;charset=UTF-8");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode("\u53cc\u5411\u7ec6\u76ee\u8868\u6a21\u7248.xlsx", "UTF-8"));
        IOUtils.copy((InputStream)in, (OutputStream)response.getOutputStream());
    }

    @PutMapping(value={"/try/{sheetName}"})
    @Operation(summary="\u5c1d\u8bd5\u5bfc\u5165\u53cc\u5411\u7ec6\u76ee\u8868")
    @PreAuthorize(value="hasAnyAuthority('twoway-detail-table-try')")
    public Result tryImportTwoWaySheet(@RequestParam(value="file") MultipartFile file, @PathVariable String sheetName) throws Exception {
        TwoWaySheet twoWaySheet = TwoWayDetailTableUtils.importTwoWayDetailTable((MultipartFile)file, (String)sheetName);
        return Result.success((Object)twoWaySheet);
    }

    @PutMapping(value={"/import/{termId}/{subjectId}/{specialtyId}/{gradeId}/{subjectType}/{questionTypes}/{type}/{sheetName}"})
    @Operation(summary="\u5bfc\u5165\u53cc\u5411\u7ec6\u76ee\u8868")
    @PreAuthorize(value="hasAnyAuthority('twoway-detail-table-import')")
    public Result importTwoWaySheet(@RequestParam(value="file") MultipartFile file, @PathVariable Long termId, @PathVariable Long subjectId, @PathVariable Long specialtyId, @PathVariable Long gradeId, @PathVariable Integer subjectType, @PathVariable Integer type, @PathVariable String questionTypes, @PathVariable String sheetName) throws Exception {
        TwoWaySheet twoWaySheet = TwoWayDetailTableUtils.importTwoWayDetailTable((MultipartFile)file, (String)sheetName);
        TwoWaySheetHead twoWaySheetHead = twoWaySheet.getHead();
        List head = twoWaySheetHead.getHead();
        List questionType = head.subList(5, head.size());
        List rows = twoWaySheet.getRows();
        ArrayList<TwowayDetailTable> importResult = new ArrayList<TwowayDetailTable>();
        List<String> questionTypeList = Arrays.stream(questionTypes.split(",")).toList();
        ArrayList<TwowayDetailTableErrorVO> errorList = new ArrayList<TwowayDetailTableErrorVO>();
        for (List row : rows) {
            if (row.size() < head.size()) continue;
            TwowayDetailTable twowayDetailTable = new TwowayDetailTable();
            twowayDetailTable.setGradeId(gradeId);
            twowayDetailTable.setSubjectId(subjectId);
            twowayDetailTable.setTermId(termId);
            twowayDetailTable.setSpecialtyId(specialtyId);
            twowayDetailTable.setType(subjectType);
            String serial = (String)row.get(0);
            if (serial.equals("\u5408\u8ba1")) continue;
            twowayDetailTable.setSerial(Integer.valueOf(Integer.parseInt(serial)));
            twowayDetailTable.setExamKey((String)row.get(1));
            twowayDetailTable.setRequired((String)row.get(2));
            twowayDetailTable.setTextbookName((String)row.get(3));
            twowayDetailTable.setChapterModule((String)row.get(4));
            twowayDetailTable.setType(type);
            for (int i = 0; i < questionType.size(); ++i) {
                String q = (String)questionType.get(i);
                String content = (String)row.get(i + 5);
                if (StringUtils.isBlank((CharSequence)content) || StringUtils.isBlank((CharSequence)q) || q.equals("\u5c0f\u8ba1") || !questionTypeList.contains(q)) continue;
                if (q.equals("\u5355\u9009\u9898") && questionTypeList.contains("\u5355\u9009\u9898")) {
                    twowayDetailTable.setSingleChoiceQuestion(Integer.valueOf(Integer.parseInt(content)));
                    continue;
                }
                if (q.equals("\u591a\u9009\u9898") && questionTypeList.contains("\u591a\u9009\u9898")) {
                    twowayDetailTable.setMultipleChoiceQuestion(Integer.valueOf(Integer.parseInt(content)));
                    continue;
                }
                if (q.equals("\u586b\u7a7a\u9898") && questionTypeList.contains("\u586b\u7a7a\u9898")) {
                    twowayDetailTable.setFillQuestion(Integer.valueOf(Integer.parseInt(content)));
                    continue;
                }
                if (q.equals("\u5224\u65ad\u9898") && questionTypeList.contains("\u5224\u65ad\u9898")) {
                    twowayDetailTable.setJudgementQuestion(Integer.valueOf(Integer.parseInt(content)));
                    continue;
                }
                if (q.equals("\u95ee\u7b54\u9898") && questionTypeList.contains("\u95ee\u7b54\u9898")) {
                    twowayDetailTable.setAnswerQuestion(Integer.valueOf(Integer.parseInt(content)));
                    continue;
                }
                if (q.equals("\u7ec4\u5408\u9898") && questionTypeList.contains("\u7ec4\u5408\u9898")) {
                    twowayDetailTable.setCombinationQuestion(Integer.valueOf(Integer.parseInt(content)));
                    continue;
                }
                TwowayDetailTableErrorVO twowayDetailTableErrorVO = TwowayDetailTableErrorVO.of((TwowayDetailTable)twowayDetailTable);
                twowayDetailTableErrorVO.setErrorMsg("\u9898\u76ee\u7c7b\u578b\u9519\u8bef\uff0c\u8bf7\u5728\u5355\u9009\u9898\u3001\u591a\u9009\u9898\u3001\u586b\u7a7a\u9898\u3001\u5224\u65ad\u9898\u3001\u95ee\u7b54\u9898\u3001\u7ec4\u5408\u9898\u4e2d\u9009\u62e9");
                errorList.add(twowayDetailTableErrorVO);
            }
            twowayDetailTable.setTotal(twowayDetailTable.getQuestionTotal());
            this.twowayDetailTableService.add(twowayDetailTable);
            importResult.add(twowayDetailTable);
        }
        if (errorList.size() > 1) {
            return Result.failed(errorList, (String)"\u5bfc\u5165\u5931\u8d25");
        }
        return Result.success(importResult);
    }
}

