/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.zsy.exam.common.result.Result;
import com.zsy.exam.util.MinioUtil;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/upload"})
@Tag(name="\u7edf\u4e00\u4e0a\u4f20", description="\u7edf\u4e00\u4e0a\u4f20")
public class UploadController {
    @Autowired
    MinioUtil minioUtil;
    @Value(value="${minio.endpointView}")
    private String endpointView;

    @PostMapping
    @PreAuthorize(value="hasAnyAuthority('upload-upload')")
    @Operation(summary="\u4e0a\u4f20")
    public Result upload(@RequestPart(value="file") MultipartFile file) {
        try {
            if (file != null) {
                return Result.ok((Object)this.minioUtil.upload(file, Integer.valueOf(0)));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u4e0a\u4f20\u5931\u8d25", e);
        }
        return Result.failed((String)"\u4e0a\u4f20\u5931\u8d25");
    }

    @GetMapping
    @PreAuthorize(value="hasAnyAuthority('upload-get')")
    @Operation(summary="\u83b7\u53d6minio\u7684\u524d\u7f00url,\u7528\u4e8e\u524d\u7aef\u5c55\u793a")
    public Result<String> getMinioEndpointView() {
        return Result.ok((Object)this.endpointView);
    }

    public List<String> getMysqlDemoUsedPic() {
        return null;
    }
}

