/*
 * Decompiled with CFR 0.152.
 */
package com.zsy.exam.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.zsy.exam.common.result.Result;
import com.zsy.exam.model.dto.UploadFileTypeChangeStatusDto;
import com.zsy.exam.model.dto.UploadFileTypeDto;
import com.zsy.exam.model.entity.UploadFileType;
import com.zsy.exam.service.IUploadFileTypeService;
import io.swagger.v3.oas.annotations.Operation;
import java.util.List;
import java.util.Map;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/file/type"})
@RestController
public class UploadFileTypeController {
    private final IUploadFileTypeService dcFileTypeService;

    @Operation(summary="\u5206\u9875\u67e5\u8be2")
    @GetMapping(value={"/page"})
    @PreAuthorize(value="hasAnyAuthority('file-type-page')")
    public Result<IPage<UploadFileType>> getPage(Page page, String type) {
        return Result.ok((Object)this.dcFileTypeService.getPage(page, type));
    }

    @Operation(summary="\u5206\u7ec4\u83b7\u53d6")
    @GetMapping(value={"/groupByType"})
    @PreAuthorize(value="hasAnyAuthority('file-type-groupByType')")
    public Result<Map<String, List<UploadFileType>>> getPage() {
        return Result.ok((Object)this.dcFileTypeService.groupByType());
    }

    @Operation(summary="\u65b0\u589e\u6587\u6863\u7c7b\u578b")
    @PostMapping(value={"/create"})
    @PreAuthorize(value="hasAnyAuthority('file-type-create')")
    public Result<Boolean> save(@Validated @RequestBody UploadFileTypeDto dto) {
        return Result.ok((Object)this.dcFileTypeService.save(dto));
    }

    @Operation(summary="\u4fee\u6539\u6587\u6863\u7c7b\u578b")
    @PutMapping(value={"/update"})
    @PreAuthorize(value="hasAnyAuthority('file-type-update')")
    public Result<Boolean> updateById(@Validated @RequestBody UploadFileTypeDto dto) {
        return Result.ok((Object)this.dcFileTypeService.update(dto));
    }

    @Operation(summary="\u4fee\u6539\u7c7b\u578b\u53ef\u7528\u6027")
    @PutMapping(value={"changeStatus"})
    @PreAuthorize(value="hasAnyAuthority('file-type-changeStatus')")
    public Result<Boolean> changeStatus(@RequestBody UploadFileTypeChangeStatusDto dto) {
        return Result.ok((Object)this.dcFileTypeService.changeStatus(dto));
    }

    @Operation(summary="\u5220\u9664\u6587\u6863\u7c7b\u578b")
    @DeleteMapping(value={"/delete/{id}"})
    @PreAuthorize(value="hasAnyAuthority('file-type-delete')")
    public Result<Boolean> delete(@PathVariable(value="id") Long id) {
        return Result.ok((Object)this.dcFileTypeService.delete(id));
    }

    public UploadFileTypeController(IUploadFileTypeService dcFileTypeService) {
        this.dcFileTypeService = dcFileTypeService;
    }
}

